/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum DeleteGranularity {
    FILE,
    PARTITION;


    public String toString() {
        switch (this) {
            case FILE: {
                return "file";
            }
            case PARTITION: {
                return "partition";
            }
        }
        throw new IllegalArgumentException("Unknown delete granularity: " + String.valueOf((Object)this));
    }

    public static DeleteGranularity fromString(String valueAsString) {
        Preconditions.checkArgument((valueAsString != null ? 1 : 0) != 0, (Object)"Value is null");
        if (FILE.toString().equalsIgnoreCase(valueAsString)) {
            return FILE;
        }
        if (PARTITION.toString().equalsIgnoreCase(valueAsString)) {
            return PARTITION;
        }
        throw new IllegalArgumentException("Unknown delete granularity: " + valueAsString);
    }
}

