/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.postgresql.converter;

import java.sql.SQLException;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;

public class PostgreSqlExceptionConverter
extends JdbcExceptionConverter {
    public GravitinoRuntimeException toGravitinoException(SQLException se) {
        if (null != se.getSQLState()) {
            switch (se.getSQLState()) {
                case "42P04": 
                case "42P06": {
                    return new SchemaAlreadyExistsException(se.getMessage(), new Object[]{se});
                }
                case "42P07": {
                    return new TableAlreadyExistsException(se.getMessage(), new Object[]{se});
                }
                case "3D000": 
                case "3F000": {
                    return new NoSuchSchemaException(se.getMessage(), new Object[]{se});
                }
                case "42P01": {
                    return new NoSuchTableException(se.getMessage(), new Object[]{se});
                }
            }
            return new GravitinoRuntimeException(se.getMessage(), new Object[]{se});
        }
        if (se.getMessage() != null && se.getMessage().contains("password authentication failed")) {
            return new ConnectionFailedException(se.getMessage(), new Object[]{se});
        }
        return new GravitinoRuntimeException(se.getMessage(), new Object[]{se});
    }
}

