/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.utils;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.DescribeIcebergSortOrderVisitor;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.transforms.SortOrderVisitor;

public class IcebergTablePropertiesUtil {
    public static Map<String, String> buildReservedProperties(TableMetadata table) {
        Set identifierFields;
        HashMap<String, String> properties = new HashMap<String, String>();
        String fileFormat = table.properties().getOrDefault("write.format.default", "parquet");
        properties.put("format", String.join((CharSequence)"/", "iceberg", fileFormat));
        properties.put("provider", "iceberg");
        String currentSnapshotId = table.currentSnapshot() != null ? String.valueOf(table.currentSnapshot().snapshotId()) : "none";
        properties.put("current-snapshot-id", currentSnapshotId);
        properties.put("location", table.location());
        properties.put("format-version", String.valueOf(table.formatVersion()));
        if (!table.sortOrder().isUnsorted()) {
            properties.put("sort-order", IcebergTablePropertiesUtil.describeIcebergSortOrder(table.sortOrder()));
        }
        if (!(identifierFields = table.schema().identifierFieldNames()).isEmpty()) {
            properties.put("identifier-fields", "[" + String.join((CharSequence)",", identifierFields) + "]");
        }
        return properties;
    }

    private static String describeIcebergSortOrder(SortOrder sortOrder) {
        return Joiner.on((String)", ").join((Iterable)SortOrderVisitor.visit((SortOrder)sortOrder, (SortOrderVisitor)DescribeIcebergSortOrderVisitor.INSTANCE));
    }

    private IcebergTablePropertiesUtil() {
    }
}

