/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.converter;

import java.util.ArrayList;
import java.util.List;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class FromIcebergType
extends TypeUtil.SchemaVisitor<Type> {
    public static final int PRECISION_MICROSECOND = 6;

    public Type schema(Schema schema, Type structType) {
        throw new UnsupportedOperationException("Data conversion of schema type is not supported");
    }

    public Type struct(Types.StructType struct, List<Type> fieldResults) {
        ArrayList<Types.StructType.Field> fieldsList = new ArrayList<Types.StructType.Field>();
        List originalFields = struct.fields();
        for (int i = 0; i < originalFields.size(); ++i) {
            Types.NestedField nestedField = (Types.NestedField)originalFields.get(i);
            fieldsList.add(Types.StructType.Field.of((String)nestedField.name(), (Type)fieldResults.get(i), (boolean)nestedField.isOptional(), (String)nestedField.doc()));
        }
        return Types.StructType.of((Types.StructType.Field[])fieldsList.toArray(new Types.StructType.Field[0]));
    }

    public Type field(Types.NestedField field, Type fieldResult) {
        return fieldResult;
    }

    public Type list(Types.ListType list, Type elementResult) {
        return Types.ListType.of((Type)elementResult, (boolean)list.isElementOptional());
    }

    public Type map(Types.MapType map, Type keyResult, Type valueResult) {
        return Types.MapType.of((Type)keyResult, (Type)valueResult, (boolean)map.isValueOptional());
    }

    public Type primitive(Type.PrimitiveType primitive) {
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case INTEGER: {
                return Types.IntegerType.get();
            }
            case LONG: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case DATE: {
                return Types.DateType.get();
            }
            case TIME: {
                return Types.TimeType.of((int)6);
            }
            case TIMESTAMP: {
                Types.TimestampType ts = (Types.TimestampType)primitive;
                if (ts.shouldAdjustToUTC()) {
                    return Types.TimestampType.withTimeZone((int)6);
                }
                return Types.TimestampType.withoutTimeZone((int)6);
            }
            case STRING: {
                return Types.StringType.get();
            }
            case UUID: {
                return Types.UUIDType.get();
            }
            case FIXED: {
                Types.FixedType fixedType = (Types.FixedType)primitive;
                return Types.FixedType.of((int)fixedType.length());
            }
            case BINARY: {
                return Types.BinaryType.get();
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                return Types.DecimalType.of((int)decimal.precision(), (int)decimal.scale());
            }
        }
        return Types.ExternalType.of((String)primitive.typeId().name());
    }
}

