/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.gravitino.connector.BaseSchema;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;

public class IcebergSchema
extends BaseSchema {
    private IcebergSchema() {
    }

    public CreateNamespaceRequest toCreateRequest(Namespace namespace) {
        HashMap meta = Maps.newHashMap();
        if (MapUtils.isNotEmpty((Map)this.properties)) {
            meta.putAll(this.properties);
        }
        if (null != this.comment) {
            meta.put("comment", this.comment);
        }
        return CreateNamespaceRequest.builder().setProperties((Map)meta).withNamespace(namespace).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "IcebergSchema()";
    }

    public static class Builder
    extends BaseSchema.BaseSchemaBuilder<Builder, IcebergSchema> {
        private Builder() {
        }

        protected IcebergSchema internalBuild() {
            IcebergSchema icebergSchema = new IcebergSchema();
            icebergSchema.name = this.name;
            if (null == this.comment) {
                if (null == this.properties) {
                    icebergSchema.comment = null;
                } else {
                    icebergSchema.comment = (String)this.properties.get("comment");
                }
            } else {
                icebergSchema.comment = this.comment;
            }
            icebergSchema.properties = this.properties;
            icebergSchema.auditInfo = this.auditInfo;
            return icebergSchema;
        }
    }
}

