/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.fragment;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DataFile
implements Serializable {
    private static final long serialVersionUID = -2827710928026343591L;
    private final String path;
    private final int[] fields;
    private final int[] columnIndices;
    private final int fileMajorVersion;
    private final int fileMinorVersion;
    private final Long fileSizeBytes;
    private final Integer baseId;

    public DataFile(String path, int[] fields, int[] columnIndices, int fileMajorVersion, int fileMinorVersion, Long fileSizeBytes, Integer baseId) {
        this.path = path;
        this.fields = fields;
        this.columnIndices = columnIndices;
        this.fileMajorVersion = fileMajorVersion;
        this.fileMinorVersion = fileMinorVersion;
        this.fileSizeBytes = fileSizeBytes;
        this.baseId = baseId;
    }

    public String getPath() {
        return this.path;
    }

    public int[] getFields() {
        return this.fields;
    }

    public int[] getColumnIndices() {
        return this.columnIndices;
    }

    public int getFileMajorVersion() {
        return this.fileMajorVersion;
    }

    public int getFileMinorVersion() {
        return this.fileMinorVersion;
    }

    public Long getFileSizeBytes() {
        return this.fileSizeBytes;
    }

    public Optional<Integer> getBaseId() {
        return Optional.ofNullable(this.baseId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFile that = (DataFile)o;
        return this.fileMajorVersion == that.fileMajorVersion && this.fileMinorVersion == that.fileMinorVersion && Objects.equals(this.path, that.path) && Arrays.equals(this.fields, that.fields) && Arrays.equals(this.columnIndices, that.columnIndices) && Objects.equals(this.fileSizeBytes, that.fileSizeBytes);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("path", (Object)this.path).append("fields", this.fields).append("columnIndices", this.columnIndices).append("fileMajorVersion", this.fileMajorVersion).append("fileMinorVersion", this.fileMinorVersion).append("fileSizeBytes", (Object)this.fileSizeBytes).append("baseId", (Object)this.baseId).toString();
    }
}

