/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ReadOptions {
    private final Optional<Integer> version;
    private final Optional<Integer> blockSize;
    private final long indexCacheSizeBytes;
    private final long metadataCacheSizeBytes;
    private final Map<String, String> storageOptions;

    private ReadOptions(Builder builder) {
        this.version = builder.version;
        this.blockSize = builder.blockSize;
        this.indexCacheSizeBytes = builder.indexCacheSizeBytes;
        this.metadataCacheSizeBytes = builder.metadataCacheSizeBytes;
        this.storageOptions = builder.storageOptions;
    }

    public Optional<Integer> getVersion() {
        return this.version;
    }

    public Optional<Integer> getBlockSize() {
        return this.blockSize;
    }

    public long getIndexCacheSizeBytes() {
        return this.indexCacheSizeBytes;
    }

    public long getMetadataCacheSizeBytes() {
        return this.metadataCacheSizeBytes;
    }

    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("version", this.version.orElse(null)).append("blockSize", this.blockSize.orElse(null)).append("indexCacheSizeBytes", this.indexCacheSizeBytes).append("metadataCacheSizeBytes", this.metadataCacheSizeBytes).append("storageOptions", this.storageOptions).toString();
    }

    public static class Builder {
        private Optional<Integer> version = Optional.empty();
        private Optional<Integer> blockSize = Optional.empty();
        private long indexCacheSizeBytes = Integer.MIN_VALUE;
        private long metadataCacheSizeBytes = 0x40000000L;
        private Map<String, String> storageOptions = new HashMap<String, String>();

        public Builder setVersion(int version) {
            this.version = Optional.of(version);
            return this;
        }

        public Builder setBlockSize(int blockSize) {
            this.blockSize = Optional.of(blockSize);
            return this;
        }

        public Builder setIndexCacheSizeBytes(long indexCacheSizeBytes) {
            this.indexCacheSizeBytes = indexCacheSizeBytes;
            return this;
        }

        @Deprecated
        public Builder setIndexCacheSize(int indexCacheSize) {
            long assumedEntrySize = 0x1400000L;
            this.indexCacheSizeBytes = (long)indexCacheSize * assumedEntrySize;
            return this;
        }

        public Builder setMetadataCacheSizeBytes(long metadataCacheSizeBytes) {
            this.metadataCacheSizeBytes = metadataCacheSizeBytes;
            return this;
        }

        @Deprecated
        public Builder setMetadataCacheSize(int metadataCacheSize) {
            long assumedEntrySize = 0x400000L;
            this.metadataCacheSizeBytes = (long)metadataCacheSize * assumedEntrySize;
            return this;
        }

        public Builder setStorageOptions(Map<String, String> storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        public ReadOptions build() {
            return new ReadOptions(this);
        }
    }
}

