/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedObjectDoubleProcedure;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;

public abstract class AbstractImmutableObjectDoubleMap<V>
implements ImmutableObjectDoubleMap<V> {

    protected static class ImmutableObjectDoubleMapSerializationProxy<V>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ObjectDoubleMap<V> map;

        public ImmutableObjectDoubleMapSerializationProxy() {
        }

        protected ImmutableObjectDoubleMapSerializationProxy(ObjectDoubleMap<V> map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((ObjectDoubleProcedure)new CheckedObjectDoubleProcedure<V>(){

                    @Override
                    public void safeValue(V key, double value) throws IOException {
                        out.writeObject(key);
                        out.writeDouble(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ObjectDoubleHashMap deserializedMap = new ObjectDoubleHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readObject(), in.readDouble());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

