/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.hudi.utils;

import java.util.Locale;
import java.util.Map;
import org.apache.gravitino.catalog.lakehouse.hudi.backend.BackendType;
import org.apache.gravitino.catalog.lakehouse.hudi.backend.HudiCatalogBackend;
import org.apache.gravitino.catalog.lakehouse.hudi.backend.hms.HudiHMSBackend;

public class CatalogUtils {
    public static final String CATALOG_ID_KEY = "catalogId";

    private CatalogUtils() {
    }

    public static HudiCatalogBackend loadHudiCatalogBackend(Map<String, String> properties) {
        BackendType backendType = BackendType.valueOf(properties.get("catalog-backend").toUpperCase(Locale.ROOT));
        switch (backendType) {
            case HMS: {
                HudiHMSBackend hudiHMSBackend = new HudiHMSBackend();
                ((HudiCatalogBackend)hudiHMSBackend).initialize(properties);
                return hudiHMSBackend;
            }
        }
        throw new UnsupportedOperationException("Unsupported backend type: " + String.valueOf((Object)backendType));
    }
}

