/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.common;

import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.util.PrettyPrintable;
import java.io.IOException;
import java.util.List;

public class PrettyPrinter {
    PrettyPrinter() {
    }

    public static String prettyPrint(PrettyPrintable tree) {
        StringBuilder sb = new StringBuilder();
        PrettyPrinter.prettyPrint(tree.getNode(), sb, "", true, true);
        return sb.toString();
    }

    public static void prettyPrint(PrettyPrintable tree, Appendable appendable) {
        PrettyPrinter.prettyPrint(tree.getNode(), appendable, "", true, true);
    }

    static void prettyPrint(Node node, Appendable sb, String prefix, boolean isTail, boolean isRoot) {
        try {
            StringBuilder label = new StringBuilder();
            if (isRoot) {
                label.append("\u25cb");
                if (node.getIncomingEdge().length() > 0) {
                    label.append(" ");
                }
            }
            label.append(node.getIncomingEdge());
            if (node.getValue() != null) {
                label.append(" (").append(node.getValue()).append(")");
            }
            sb.append(prefix).append(isTail ? (isRoot ? "" : "\u2514\u2500\u2500 \u25cb ") : "\u251c\u2500\u2500 \u25cb ").append(label).append("\n");
            List<Node> children = node.getOutgoingEdges();
            for (int i = 0; i < children.size() - 1; ++i) {
                PrettyPrinter.prettyPrint(children.get(i), sb, prefix + (isTail ? (isRoot ? "" : "    ") : "\u2502   "), false, false);
            }
            if (!children.isEmpty()) {
                PrettyPrinter.prettyPrint(children.get(children.size() - 1), sb, prefix + (isTail ? (isRoot ? "" : "    ") : "\u2502   "), true, false);
            }
        }
        catch (IOException ioException) {
            throw new IllegalStateException(ioException);
        }
    }
}

