/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.script;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.runtime.JavaMethodReflectionFunctionMissing;
import com.googlecode.aviator.script.AviatorBindings;
import com.googlecode.aviator.script.AviatorScriptEngineFactory;
import com.googlecode.aviator.script.CompiledAviatorScript;
import com.googlecode.aviator.utils.Utils;
import com.googlecode.aviator.utils.VarNameGenerator;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;

public class AviatorScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private static final int KEY_THRESHOLD = 4096;
    private boolean cached = true;
    private final AviatorScriptEngineFactory factory;
    private final AviatorEvaluatorInstance engine;
    public static final ThreadLocal<VarNameGenerator> TEMP_VAR_GEN = new ThreadLocal<VarNameGenerator>(){

        @Override
        protected VarNameGenerator initialValue() {
            return new VarNameGenerator();
        }
    };
    private final DynamicFunctionInvocationHandler functionProxyHandler = new DynamicFunctionInvocationHandler();

    public AviatorScriptEngine() {
        this.factory = AviatorScriptEngineFactory.newInstance();
        this.engine = AviatorEvaluator.newInstance();
        this.engine.setFunctionMissing(JavaMethodReflectionFunctionMissing.getInstance());
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        AviatorBindings bindings = (AviatorBindings)this.createBindings(this.context.getBindings(100));
        bindings.setmOverrides((Map)thiz);
        return this.invokeFunction(name, this.createBindings(bindings), args);
    }

    public AviatorEvaluatorInstance getEngine() {
        return this.engine;
    }

    private String genVar() {
        return TEMP_VAR_GEN.get().gen();
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Bindings bindings = this.createBindings(this.context.getBindings(100));
        return this.invokeFunction(name, bindings, args);
    }

    private Object invokeFunction(String name, Bindings bindings, Object ... args) throws ScriptException {
        StringBuilder sb = new StringBuilder(name);
        sb.append("(");
        if (args != null) {
            boolean wasFirst = true;
            for (Object arg : args) {
                String var = this.genVar();
                bindings.put(var, arg);
                if (wasFirst) {
                    sb.append(var);
                    wasFirst = false;
                    continue;
                }
                sb.append(",").append(var);
            }
        }
        sb.append(")");
        return this.eval(sb.toString(), bindings);
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        return (T)Proxy.newProxyInstance(clasz.getClassLoader(), new Class[]{clasz}, (InvocationHandler)this.functionProxyHandler);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        return (T)Proxy.newProxyInstance(clasz.getClassLoader(), new Class[]{clasz}, (InvocationHandler)new DynamicMethodInvocationHandler(thiz));
    }

    public AviatorScriptEngine(Bindings n) {
        super(n);
        this.factory = AviatorScriptEngineFactory.newInstance();
        this.engine = AviatorEvaluator.newInstance();
    }

    public AviatorScriptEngine(AviatorScriptEngineFactory factory) {
        this.factory = factory;
        this.engine = AviatorEvaluator.newInstance();
        this.engine.setFunctionMissing(JavaMethodReflectionFunctionMissing.getInstance());
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return new CompiledAviatorScript(this, this.engine.compile(this.getCachingKey(script), script, this.cached));
    }

    public String getCachingKey(String script) {
        if (script.length() < 4096) {
            return script;
        }
        return Utils.md5sum(script);
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            return this.compile(Utils.readFully(script));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    public Bindings createBindings(Bindings parent) {
        AviatorBindings bindings = new AviatorBindings(parent);
        bindings.setInstance(this.engine);
        return bindings;
    }

    @Override
    public Bindings createBindings() {
        AviatorBindings bindings = new AviatorBindings();
        bindings.setInstance(this.engine);
        return bindings;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.compile(script).eval(context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            return this.eval(Utils.readFully(reader), context);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    private class DynamicMethodInvocationHandler
    implements InvocationHandler {
        private final Object thiz;

        public DynamicMethodInvocationHandler(Object thiz) {
            this.thiz = thiz;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            return AviatorScriptEngine.this.invokeMethod(this.thiz, name, args);
        }
    }

    private class DynamicFunctionInvocationHandler
    implements InvocationHandler {
        private DynamicFunctionInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            return AviatorScriptEngine.this.invokeFunction(name, args);
        }
    }
}

