/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import java.util.Map;
import java.util.Set;

public class SeqIncludeFunction
extends AbstractFunction {
    private static final long serialVersionUID = 2484898649434036343L;

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Object first = arg1.getValue(env);
        if (first == null) {
            return AviatorBoolean.FALSE;
        }
        Class<?> clazz = first.getClass();
        boolean contains = false;
        if (Set.class.isAssignableFrom(clazz)) {
            contains = ((Set)first).contains(arg2.getValue(env));
        } else {
            try {
                for (Object obj : RuntimeUtils.seq(first, env)) {
                    if (AviatorRuntimeJavaType.valueOf(obj).compareEq(arg2, env) != 0) continue;
                    contains = true;
                    break;
                }
            }
            catch (Exception e) {
                RuntimeUtils.printStackTrace(env, e);
                return AviatorBoolean.FALSE;
            }
        }
        return AviatorBoolean.valueOf(contains);
    }

    @Override
    public String getName() {
        return "include";
    }
}

