/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.operation;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.gravitino.catalog.jdbc.JdbcTable;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.rel.SupportsPartitions;

public abstract class JdbcTablePartitionOperations
implements TableOperations,
SupportsPartitions {
    protected final DataSource dataSource;
    protected final JdbcTable loadedTable;

    protected JdbcTablePartitionOperations(DataSource dataSource, JdbcTable loadedTable) {
        Preconditions.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"dataSource is null");
        Preconditions.checkArgument((loadedTable != null ? 1 : 0) != 0, (Object)"loadedTable is null");
        this.dataSource = dataSource;
        this.loadedTable = loadedTable;
    }

    protected Connection getConnection(String databaseName) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setCatalog(databaseName);
        return connection;
    }

    public void close() throws IOException {
    }
}

