/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.circuitBreaker;

import io.micrometer.common.lang.NonNull;
import io.micrometer.core.instrument.MeterRegistry;
import io.openlineage.client.circuitBreaker.CircuitBreaker;
import io.openlineage.client.circuitBreaker.CircuitBreakerState;
import io.openlineage.client.circuitBreaker.TaskQueueCircuitBreakerConfig;
import io.openlineage.client.metrics.MicrometerProvider;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueueCircuitBreaker
implements CircuitBreaker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskQueueCircuitBreaker.class);
    public static final String TASK_QUEUE_METRIC_PREFIX = "openlineage.circuitbreaker.taskqueue.";
    public static final String DROPPED_METRIC = "openlineage.circuitbreaker.taskqueue.dropped";
    public static final String TIMED_OUT_METRIC = "openlineage.circuitbreaker.taskqueue.timedout";
    public static final String FAILED_METRIC = "openlineage.circuitbreaker.taskqueue.failed";
    private BlockingQueue<Runnable> eventQueue;
    private ExecutorService eventProcessingExecutor;
    private Long blockingTimeInSeconds;
    private Long shutdownTimeoutSeconds;

    public TaskQueueCircuitBreaker(@NonNull TaskQueueCircuitBreakerConfig config) {
        this.blockingTimeInSeconds = config.getBlockingTimeInSeconds();
        this.shutdownTimeoutSeconds = config.getShutdownTimeoutSeconds();
        this.eventQueue = new ArrayBlockingQueue<Runnable>(config.getQueueSize());
        this.eventProcessingExecutor = new ThreadPoolExecutor(config.getThreadCount(), config.getThreadCount(), 60L, TimeUnit.SECONDS, this.eventQueue);
    }

    @Override
    public CircuitBreakerState currentState() {
        return new CircuitBreakerState(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Callable<T> callable) {
        try {
            T result;
            T t = result = this.eventProcessingExecutor.submit(callable).get(this.blockingTimeInSeconds, TimeUnit.SECONDS);
            return t;
        }
        catch (RejectedExecutionException re) {
            this.incrementCounter(DROPPED_METRIC);
            T t = null;
            return t;
        }
        catch (TimeoutException e) {
            this.incrementCounter(TIMED_OUT_METRIC);
            T t = null;
            return t;
        }
        catch (Exception e) {
            this.incrementCounter(FAILED_METRIC);
            T t = null;
            return t;
        }
        finally {
            Optional.ofNullable(MicrometerProvider.getMeterRegistry()).ifPresent(m -> log.info("Openlineage async stats: dropped={}, timeout={}, queueDepth={}, failed={}", new Object[]{m.counter(DROPPED_METRIC, new String[0]).count(), m.counter(TIMED_OUT_METRIC, new String[0]).count(), this.getPendingTasks(), m.counter(FAILED_METRIC, new String[0]).count()}));
        }
    }

    private void incrementCounter(String metric) {
        MeterRegistry meterRegistry = MicrometerProvider.getMeterRegistry();
        if (meterRegistry != null) {
            meterRegistry.counter(metric, new String[0]).increment();
        }
    }

    public int getPendingTasks() {
        return this.eventQueue == null ? 0 : this.eventQueue.size();
    }

    @Override
    public int getCheckIntervalMillis() {
        return CircuitBreaker.super.getCheckIntervalMillis();
    }

    @Override
    public void close() {
        try {
            this.eventProcessingExecutor.shutdown();
            this.eventProcessingExecutor.awaitTermination(this.shutdownTimeoutSeconds, TimeUnit.SECONDS);
            List<Runnable> canceledTasks = this.eventProcessingExecutor.shutdownNow();
            Optional.ofNullable(MicrometerProvider.getMeterRegistry()).ifPresent(m -> m.counter(FAILED_METRIC, new String[0]).increment((double)canceledTasks.size()));
        }
        catch (Exception e) {
            log.error("Unable to shutdown pending event processing tasks", (Throwable)e);
        }
    }
}

