/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.GetOwnerEvent;
import org.apache.gravitino.listener.api.event.GetOwnerFailureEvent;
import org.apache.gravitino.listener.api.event.GetOwnerPreEvent;
import org.apache.gravitino.listener.api.event.SetOwnerEvent;
import org.apache.gravitino.listener.api.event.SetOwnerFailureEvent;
import org.apache.gravitino.listener.api.event.SetOwnerPreEvent;
import org.apache.gravitino.listener.api.info.OwnerInfo;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class OwnerEventManager
implements OwnerDispatcher {
    private final EventBus eventBus;
    private OwnerDispatcher ownerDispatcher;

    public OwnerEventManager(EventBus eventBus, OwnerDispatcher ownerDispatcher) {
        this.eventBus = eventBus;
        this.ownerDispatcher = ownerDispatcher;
    }

    @VisibleForTesting
    public void setOwnerManager(OwnerDispatcher ownerDispatcher) {
        this.ownerDispatcher = ownerDispatcher;
    }

    @Override
    public void setOwner(String metalake, MetadataObject metadataObject, String ownerName, Owner.Type ownerType) {
        NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
        String user = PrincipalUtils.getCurrentUserName();
        OwnerInfo ownerInfo = new OwnerInfo(ownerName, ownerType);
        MetadataObject.Type type = metadataObject.type();
        this.eventBus.dispatchEvent(new SetOwnerPreEvent(user, identifier, ownerInfo, type));
        try {
            this.ownerDispatcher.setOwner(metalake, metadataObject, ownerName, ownerType);
            this.eventBus.dispatchEvent(new SetOwnerEvent(user, identifier, ownerInfo, type));
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new SetOwnerFailureEvent(user, identifier, e, ownerInfo, type));
            throw e;
        }
    }

    @Override
    public Optional<Owner> getOwner(String metalake, MetadataObject metadataObject) {
        NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
        String user = PrincipalUtils.getCurrentUserName();
        OwnerInfo ownerInfo = null;
        MetadataObject.Type type = metadataObject.type();
        this.eventBus.dispatchEvent(new GetOwnerPreEvent(user, identifier, ownerInfo, type));
        try {
            Optional<Owner> owner = this.ownerDispatcher.getOwner(metalake, metadataObject);
            if (owner.isPresent()) {
                ownerInfo = new OwnerInfo(owner.get().name(), owner.get().type());
            }
            this.eventBus.dispatchEvent(new GetOwnerEvent(user, identifier, ownerInfo, type));
            return owner;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetOwnerFailureEvent(user, identifier, e, ownerInfo, type));
            throw e;
        }
    }

    public OwnerDispatcher getOwnerDispatcher() {
        return this.ownerDispatcher;
    }
}

