/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class IncrementalBlockReportManager {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalBlockReportManager.class);
    private final Map<DatanodeStorage, PerStorageIBR> pendingIBRs = Maps.newHashMap();
    private volatile boolean readyToSend = false;
    private final long ibrInterval;
    private volatile long lastIBR;
    private DataNodeMetrics dnMetrics;

    IncrementalBlockReportManager(long ibrInterval, DataNodeMetrics dnMetrics) {
        this.ibrInterval = ibrInterval;
        this.lastIBR = Time.monotonicNow() - ibrInterval;
        this.dnMetrics = dnMetrics;
    }

    boolean sendImmediately() {
        return this.readyToSend && Time.monotonicNow() - this.ibrInterval >= this.lastIBR;
    }

    synchronized void waitTillNextIBR(long waitTime) {
        if (waitTime > 0L && !this.sendImmediately()) {
            try {
                this.wait(this.ibrInterval > 0L && this.ibrInterval < waitTime ? this.ibrInterval : waitTime);
            }
            catch (InterruptedException ie) {
                LOG.warn(this.getClass().getSimpleName() + " interrupted");
            }
        }
    }

    private synchronized StorageReceivedDeletedBlocks[] generateIBRs() {
        ArrayList<StorageReceivedDeletedBlocks> reports = new ArrayList<StorageReceivedDeletedBlocks>(this.pendingIBRs.size());
        for (Map.Entry<DatanodeStorage, PerStorageIBR> entry : this.pendingIBRs.entrySet()) {
            PerStorageIBR perStorage = entry.getValue();
            ReceivedDeletedBlockInfo[] rdbi = perStorage.removeAll();
            if (rdbi == null) continue;
            reports.add(new StorageReceivedDeletedBlocks(entry.getKey(), rdbi));
        }
        this.dnMetrics.resetBlocksInPendingIBR();
        this.readyToSend = false;
        return reports.toArray(new StorageReceivedDeletedBlocks[reports.size()]);
    }

    private synchronized void putMissing(StorageReceivedDeletedBlocks[] reports) {
        for (StorageReceivedDeletedBlocks r : reports) {
            this.pendingIBRs.get(r.getStorage()).putMissing(r.getBlocks());
        }
        if (reports.length > 0) {
            this.readyToSend = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendIBRs(DatanodeProtocol namenode, DatanodeRegistration registration, String bpid, String nnRpcLatencySuffix) throws IOException {
        block7: {
            Object[] reports = this.generateIBRs();
            if (reports.length == 0) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("call blockReceivedAndDeleted: " + Arrays.toString(reports));
            }
            boolean success = false;
            long startTime = Time.monotonicNow();
            try {
                namenode.blockReceivedAndDeleted(registration, bpid, (StorageReceivedDeletedBlocks[])reports);
                success = true;
                if (success) {
                    this.dnMetrics.addIncrementalBlockReport(Time.monotonicNow() - startTime, nnRpcLatencySuffix);
                    this.lastIBR = startTime;
                    break block7;
                }
                this.putMissing((StorageReceivedDeletedBlocks[])reports);
            }
            catch (Throwable throwable) {
                if (success) {
                    this.dnMetrics.addIncrementalBlockReport(Time.monotonicNow() - startTime, nnRpcLatencySuffix);
                    this.lastIBR = startTime;
                } else {
                    this.putMissing((StorageReceivedDeletedBlocks[])reports);
                    LOG.warn("Failed to call blockReceivedAndDeleted: {}, nnId: {}, duration(ms): {}", new Object[]{Arrays.toString(reports), nnRpcLatencySuffix, Time.monotonicNow() - startTime});
                }
                throw throwable;
            }
            LOG.warn("Failed to call blockReceivedAndDeleted: {}, nnId: {}, duration(ms): {}", new Object[]{Arrays.toString(reports), nnRpcLatencySuffix, Time.monotonicNow() - startTime});
        }
    }

    private PerStorageIBR getPerStorageIBR(DatanodeStorage storage) {
        PerStorageIBR perStorage = this.pendingIBRs.get(storage);
        if (perStorage == null) {
            perStorage = new PerStorageIBR(this.dnMetrics);
            this.pendingIBRs.put(storage, perStorage);
        }
        return perStorage;
    }

    @VisibleForTesting
    synchronized void addRDBI(ReceivedDeletedBlockInfo rdbi, DatanodeStorage storage) {
        for (PerStorageIBR perStorage : this.pendingIBRs.values()) {
            if (perStorage.remove(rdbi.getBlock()) != null) break;
        }
        this.getPerStorageIBR(storage).put(rdbi);
    }

    synchronized void notifyNamenodeBlock(ReceivedDeletedBlockInfo rdbi, DatanodeStorage storage, boolean isOnTransientStorage) {
        this.addRDBI(rdbi, storage);
        ReceivedDeletedBlockInfo.BlockStatus status = rdbi.getStatus();
        if (status == ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK) {
            this.readyToSend = true;
        } else if (status == ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK) {
            this.triggerIBR(isOnTransientStorage);
        }
    }

    synchronized void triggerIBR(boolean force) {
        this.readyToSend = true;
        if (force) {
            this.lastIBR = Time.monotonicNow() - this.ibrInterval;
        }
        if (this.sendImmediately()) {
            this.notifyAll();
        }
    }

    @VisibleForTesting
    synchronized void triggerDeletionReportForTests() {
        this.triggerIBR(true);
        while (this.sendImmediately()) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    void clearIBRs() {
        this.pendingIBRs.clear();
    }

    @VisibleForTesting
    int getPendingIBRSize() {
        return this.pendingIBRs.size();
    }

    private static class PerStorageIBR {
        final Map<Block, ReceivedDeletedBlockInfo> blocks = Maps.newHashMap();
        private DataNodeMetrics dnMetrics;

        PerStorageIBR(DataNodeMetrics dnMetrics) {
            this.dnMetrics = dnMetrics;
        }

        ReceivedDeletedBlockInfo remove(Block block) {
            return this.blocks.remove(block);
        }

        ReceivedDeletedBlockInfo[] removeAll() {
            int size = this.blocks.size();
            if (size == 0) {
                return null;
            }
            ReceivedDeletedBlockInfo[] rdbis = this.blocks.values().toArray(new ReceivedDeletedBlockInfo[size]);
            this.blocks.clear();
            return rdbis;
        }

        void put(ReceivedDeletedBlockInfo rdbi) {
            this.blocks.put(rdbi.getBlock(), rdbi);
            this.increaseBlocksCounter(rdbi);
        }

        private void increaseBlocksCounter(ReceivedDeletedBlockInfo receivedDeletedBlockInfo) {
            switch (receivedDeletedBlockInfo.getStatus()) {
                case RECEIVING_BLOCK: {
                    this.dnMetrics.incrBlocksReceivingInPendingIBR();
                    break;
                }
                case RECEIVED_BLOCK: {
                    this.dnMetrics.incrBlocksReceivedInPendingIBR();
                    break;
                }
                case DELETED_BLOCK: {
                    this.dnMetrics.incrBlocksDeletedInPendingIBR();
                    break;
                }
            }
            this.dnMetrics.incrBlocksInPendingIBR();
        }

        int putMissing(ReceivedDeletedBlockInfo[] rdbis) {
            int count = 0;
            for (ReceivedDeletedBlockInfo rdbi : rdbis) {
                if (this.blocks.containsKey(rdbi.getBlock())) continue;
                this.put(rdbi);
                ++count;
            }
            return count;
        }
    }
}

