/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.PartitionDispatcher;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.AddPartitionEvent;
import org.apache.gravitino.listener.api.event.AddPartitionFailureEvent;
import org.apache.gravitino.listener.api.event.AddPartitionPreEvent;
import org.apache.gravitino.listener.api.event.DropPartitionEvent;
import org.apache.gravitino.listener.api.event.DropPartitionFailureEvent;
import org.apache.gravitino.listener.api.event.DropPartitionPreEvent;
import org.apache.gravitino.listener.api.event.GetPartitionEvent;
import org.apache.gravitino.listener.api.event.GetPartitionFailureEvent;
import org.apache.gravitino.listener.api.event.GetPartitionPreEvent;
import org.apache.gravitino.listener.api.event.ListPartitionEvent;
import org.apache.gravitino.listener.api.event.ListPartitionFailureEvent;
import org.apache.gravitino.listener.api.event.ListPartitionNamesEvent;
import org.apache.gravitino.listener.api.event.ListPartitionNamesFailureEvent;
import org.apache.gravitino.listener.api.event.ListPartitionNamesPreEvent;
import org.apache.gravitino.listener.api.event.ListPartitionPreEvent;
import org.apache.gravitino.listener.api.event.PartitionExistsEvent;
import org.apache.gravitino.listener.api.event.PartitionExistsFailureEvent;
import org.apache.gravitino.listener.api.event.PurgePartitionEvent;
import org.apache.gravitino.listener.api.event.PurgePartitionFailureEvent;
import org.apache.gravitino.listener.api.event.PurgePartitionPreEvent;
import org.apache.gravitino.listener.api.info.partitions.PartitionInfo;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.utils.PrincipalUtils;

public class PartitionEventDispatcher
implements PartitionDispatcher {
    private final EventBus eventBus;
    private final PartitionDispatcher dispatcher;

    public PartitionEventDispatcher(EventBus eventBus, PartitionDispatcher dispatcher) {
        this.eventBus = eventBus;
        this.dispatcher = dispatcher;
    }

    @Override
    public Partition addPartition(NameIdentifier ident, Partition partition) throws NoSuchPartitionException, PartitionAlreadyExistsException {
        this.eventBus.dispatchEvent(new AddPartitionPreEvent(PrincipalUtils.getCurrentUserName(), ident, PartitionInfo.of(partition)));
        try {
            Partition newPartition = this.dispatcher.addPartition(ident, partition);
            this.eventBus.dispatchEvent(new AddPartitionEvent(PrincipalUtils.getCurrentUserName(), ident, PartitionInfo.of(newPartition)));
            return newPartition;
        }
        catch (Exception e) {
            PartitionInfo createdPartitionInfo = PartitionInfo.of(partition);
            this.eventBus.dispatchEvent(new AddPartitionFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, createdPartitionInfo));
            throw e;
        }
    }

    @Override
    public Partition getPartition(NameIdentifier ident, String partitionName) throws NoSuchPartitionException {
        this.eventBus.dispatchEvent(new GetPartitionPreEvent(PrincipalUtils.getCurrentUserName(), ident, partitionName));
        try {
            Partition partition = this.dispatcher.getPartition(ident, partitionName);
            this.eventBus.dispatchEvent(new GetPartitionEvent(PrincipalUtils.getCurrentUserName(), ident, PartitionInfo.of(partition)));
            return partition;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetPartitionFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, partitionName));
            throw e;
        }
    }

    @Override
    public boolean dropPartition(NameIdentifier ident, String partitionName) {
        this.eventBus.dispatchEvent(new DropPartitionPreEvent(PrincipalUtils.getCurrentUserName(), ident, partitionName));
        try {
            boolean isExists = this.dispatcher.dropPartition(ident, partitionName);
            this.eventBus.dispatchEvent(new DropPartitionEvent(PrincipalUtils.getCurrentUserName(), ident, isExists, partitionName));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DropPartitionFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, partitionName));
            throw e;
        }
    }

    @Override
    public Partition[] listPartitions(NameIdentifier ident) {
        this.eventBus.dispatchEvent(new ListPartitionPreEvent(PrincipalUtils.getCurrentUserName(), ident));
        try {
            Partition[] listPartitions = this.dispatcher.listPartitions(ident);
            this.eventBus.dispatchEvent(new ListPartitionEvent(PrincipalUtils.getCurrentUserName(), ident));
            return listPartitions;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListPartitionFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    @Override
    public String[] listPartitionNames(NameIdentifier ident) {
        this.eventBus.dispatchEvent(new ListPartitionNamesPreEvent(PrincipalUtils.getCurrentUserName(), ident));
        try {
            String[] listPartitionNames = this.dispatcher.listPartitionNames(ident);
            this.eventBus.dispatchEvent(new ListPartitionNamesEvent(PrincipalUtils.getCurrentUserName(), ident));
            return listPartitionNames;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListPartitionNamesFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    @Override
    public boolean partitionExists(NameIdentifier ident, String partitionName) {
        try {
            boolean isExists = this.dispatcher.partitionExists(ident, partitionName);
            this.eventBus.dispatchEvent(new PartitionExistsEvent(PrincipalUtils.getCurrentUserName(), ident, isExists, partitionName));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new PartitionExistsFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, partitionName));
            throw e;
        }
    }

    @Override
    public boolean purgePartition(NameIdentifier ident, String partitionName) {
        this.eventBus.dispatchEvent(new PurgePartitionPreEvent(PrincipalUtils.getCurrentUserName(), ident, partitionName));
        try {
            boolean isExists = this.dispatcher.purgePartition(ident, partitionName);
            this.eventBus.dispatchEvent(new PurgePartitionEvent(PrincipalUtils.getCurrentUserName(), ident, isExists, partitionName));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new PurgePartitionFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, partitionName));
            throw e;
        }
    }
}

