/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationUtilsClient;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final Log LOG = LogFactory.getLog(DelegationTokenFetcher.class);
    private static final String WEBSERVICE = "webservice";
    private static final String RENEWER = "renewer";
    private static final String CANCEL = "cancel";
    private static final String RENEW = "renew";
    private static final String PRINT = "print";
    private static final String HELP = "help";
    private static final String HELP_SHORT = "h";

    private static void printUsage(PrintStream err) {
        err.println("fetchdt retrieves delegation tokens from the NameNode");
        err.println();
        err.println("fetchdt <opts> <token file>");
        err.println("Options:");
        err.println("  --webservice <url>  Url to contact NN on");
        err.println("  --renewer <name>    Name of the delegation token renewer");
        err.println("  --cancel            Cancel the delegation token");
        err.println("  --renew             Renew the delegation token.  Delegation token must have been fetched using the --renewer <name> option.");
        err.println("  --print             Print the delegation token");
        err.println();
        GenericOptionsParser.printGenericCommandUsage((PrintStream)err);
        ExitUtil.terminate((int)1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile((Path)file, (Configuration)conf);
        return creds.getAllTokens();
    }

    public static void main(String[] args) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTP url to reach the NameNode at");
        fetcherOptions.addOption(RENEWER, true, "Name of the delegation token renewer");
        fetcherOptions.addOption(CANCEL, false, "cancel the token");
        fetcherOptions.addOption(RENEW, false, "renew the token");
        fetcherOptions.addOption(PRINT, false, "print the token");
        fetcherOptions.addOption(HELP_SHORT, HELP, false, "print out help information");
        GenericOptionsParser parser = new GenericOptionsParser((Configuration)conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        String renewer = cmd.hasOption(RENEWER) ? cmd.getOptionValue(RENEWER) : null;
        boolean cancel = cmd.hasOption(CANCEL);
        boolean renew = cmd.hasOption(RENEW);
        final boolean print = cmd.hasOption(PRINT);
        boolean help = cmd.hasOption(HELP);
        String[] remaining = parser.getRemainingArgs();
        if (help) {
            DelegationTokenFetcher.printUsage(System.out);
            System.exit(0);
        }
        if (cancel && renew || cancel && print || renew && print || cancel && renew && print) {
            System.err.println("ERROR: Only specify cancel, renew or print.");
            DelegationTokenFetcher.printUsage(System.err);
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exacltly one token file");
            DelegationTokenFetcher.printUsage(System.err);
        }
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        final Path tokenFile = new Path(local.getWorkingDirectory(), remaining[0]);
        URLConnectionFactory connectionFactory = URLConnectionFactory.DEFAULT_SYSTEM_CONNECTION_FACTORY;
        UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Configuration)conf, renew, cancel, webUrl, connectionFactory, renewer){
            final /* synthetic */ Configuration val$conf;
            final /* synthetic */ boolean val$renew;
            final /* synthetic */ boolean val$cancel;
            final /* synthetic */ String val$webUrl;
            final /* synthetic */ URLConnectionFactory val$connectionFactory;
            final /* synthetic */ String val$renewer;
            {
                this.val$conf = configuration;
                this.val$renew = bl2;
                this.val$cancel = bl3;
                this.val$webUrl = string;
                this.val$connectionFactory = uRLConnectionFactory;
                this.val$renewer = string2;
            }

            @Override
            public Object run() throws Exception {
                if (print) {
                    DelegationTokenIdentifier id = new DelegationTokenSecretManager(0L, 0L, 0L, 0L, null).createIdentifier();
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, this.val$conf)) {
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
                        id.readFields((DataInput)in);
                        System.out.println("Token (" + id + ") for " + token.getService());
                    }
                    return null;
                }
                if (this.val$renew) {
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, this.val$conf)) {
                        if (!token.isManaged()) continue;
                        long result = token.renew(this.val$conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Renewed token for " + token.getService() + " until: " + new Date(result)));
                    }
                } else if (this.val$cancel) {
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, this.val$conf)) {
                        if (!token.isManaged()) continue;
                        token.cancel(this.val$conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Cancelled token for " + token.getService()));
                    }
                } else if (this.val$webUrl != null) {
                    Credentials creds = DelegationUtilsClient.getDTfromRemote((URLConnectionFactory)this.val$connectionFactory, (URI)new URI(this.val$webUrl), (String)this.val$renewer, null);
                    creds.writeTokenStorageFile(tokenFile, this.val$conf);
                    for (Token token : creds.getAllTokens()) {
                        System.out.println("Fetched token via " + this.val$webUrl + " for " + token.getService() + " into " + tokenFile);
                    }
                } else {
                    FileSystem fs = FileSystem.get((Configuration)this.val$conf);
                    Credentials cred = new Credentials();
                    Token[] tokens = fs.addDelegationTokens(this.val$renewer, cred);
                    cred.writeTokenStorageFile(tokenFile, this.val$conf);
                    for (Token token : tokens) {
                        System.out.println("Fetched token for " + token.getService() + " into " + tokenFile);
                    }
                }
                return null;
            }
        });
    }
}

