/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.preauth.pkinit;

import org.apache.kerby.kerberos.kerb.preauth.pkinit.IdentityOpts;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.IdentityType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public class PkinitIdentity {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processIdentityOption(IdentityOpts identityOpts, String value) {
        IdentityType idType = IdentityType.NONE;
        String residual = null;
        if (value.contains(":")) {
            if (value.startsWith("FILE:")) {
                idType = IdentityType.FILE;
            } else if (value.startsWith("PKCS11:")) {
                idType = IdentityType.PKCS11;
            } else if (value.startsWith("PKCS12:")) {
                idType = IdentityType.PKCS12;
            } else if (value.startsWith("DIR:")) {
                idType = IdentityType.DIR;
            } else {
                if (!value.startsWith("ENV:")) throw new RuntimeException("Invalid Identity option format: " + value);
                idType = IdentityType.ENVVAR;
            }
        } else {
            residual = value;
            idType = IdentityType.FILE;
        }
        identityOpts.setIdType(idType);
        switch (idType) {
            case ENVVAR: {
                PkinitIdentity.processIdentityOption(identityOpts, System.getenv(residual));
                return;
            }
            case FILE: {
                PkinitIdentity.parseFileOption(identityOpts, residual);
                return;
            }
            case PKCS11: {
                PkinitIdentity.parsePkcs11Option(identityOpts, residual);
                return;
            }
            case PKCS12: {
                PkinitIdentity.parsePkcs12Option(identityOpts, residual);
                return;
            }
            case DIR: {
                identityOpts.setCertFile(residual);
                return;
            }
        }
    }

    public static void parseFileOption(IdentityOpts identityOpts, String residual) {
        String[] parts = residual.split(",");
        String certName = parts[0];
        String keyName = null;
        if (parts.length > 1) {
            keyName = parts[1];
        }
        identityOpts.setCertFile(certName);
        identityOpts.setKeyFile(keyName);
    }

    public static void parsePkcs12Option(IdentityOpts identityOpts, String residual) {
        identityOpts.setCertFile(residual);
        identityOpts.setKeyFile(residual);
    }

    public static void parsePkcs11Option(IdentityOpts identityOpts, String residual) {
    }

    public static void loadCerts(IdentityOpts identityOpts, PrincipalName principal) {
        switch (identityOpts.getIdType()) {
            case FILE: {
                PkinitIdentity.loadCertsFromFile(identityOpts, principal);
                break;
            }
            case DIR: {
                PkinitIdentity.loadCertsFromDir(identityOpts, principal);
                break;
            }
            case PKCS11: {
                PkinitIdentity.loadCertsAsPkcs11(identityOpts, principal);
                break;
            }
            case PKCS12: {
                PkinitIdentity.loadCertsAsPkcs12(identityOpts, principal);
                break;
            }
        }
    }

    private static void loadCertsAsPkcs12(IdentityOpts identityOpts, PrincipalName principal) {
    }

    private static void loadCertsAsPkcs11(IdentityOpts identityOpts, PrincipalName principal) {
    }

    private static void loadCertsFromDir(IdentityOpts identityOpts, PrincipalName principal) {
    }

    private static void loadCertsFromFile(IdentityOpts identityOpts, PrincipalName principal) {
    }

    public static void initialize(IdentityOpts identityOpts, PrincipalName principal) {
    }
}

