/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.Text;
import org.apache.paimon.shade.org.apache.orc.impl.DynamicByteArray;
import org.apache.paimon.shade.org.apache.orc.impl.DynamicIntArray;

public class DictionaryUtils {
    private DictionaryUtils() {
    }

    public static void getTextInternal(Text result, int position, DynamicIntArray keyOffsets, DynamicByteArray byteArray) {
        int offset = keyOffsets.get(position);
        int length = position + 1 == keyOffsets.size() ? byteArray.size() - offset : keyOffsets.get(position + 1) - offset;
        byteArray.setText(result, offset, length);
    }

    public static ByteBuffer getTextInternal(int position, DynamicIntArray keyOffsets, DynamicByteArray byteArray) {
        int offset = keyOffsets.get(position);
        int length = position + 1 == keyOffsets.size() ? byteArray.size() - offset : keyOffsets.get(position + 1) - offset;
        return byteArray.get(offset, length);
    }

    public static int writeToTextInternal(OutputStream out, int position, DynamicIntArray keyOffsets, DynamicByteArray byteArray) throws IOException {
        int offset = keyOffsets.get(position);
        int length = position + 1 == keyOffsets.size() ? byteArray.size() - offset : keyOffsets.get(position + 1) - offset;
        byteArray.write(out, offset, length);
        return length;
    }

    public static boolean equalsInternal(byte[] bytes, int offset, int length, int position, DynamicIntArray keyOffsets, DynamicByteArray byteArray) {
        int byteArrayOffset = keyOffsets.get(position);
        int keyLength = position + 1 == keyOffsets.size() ? byteArray.size() - byteArrayOffset : keyOffsets.get(position + 1) - byteArrayOffset;
        return 0 == byteArray.compare(bytes, offset, length, byteArrayOffset, keyLength);
    }
}

