/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.io.airlift.compress.deflate;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.paimon.shade.io.airlift.compress.hadoop.HadoopInputStream;

class JdkDeflateHadoopInputStream
extends HadoopInputStream {
    private final byte[] oneByte = new byte[1];
    private final InputStream input;
    private final Inflater inflater;
    private final byte[] inputBuffer;
    private int inputBufferEnd;
    private boolean closed;

    public JdkDeflateHadoopInputStream(InputStream input, int bufferSize) {
        this.input = Objects.requireNonNull(input, "input is null");
        this.inflater = new Inflater();
        this.inputBuffer = new byte[bufferSize];
    }

    @Override
    public int read() throws IOException {
        int length = this.read(this.oneByte, 0, 1);
        if (length < 0) {
            return length;
        }
        return this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] output, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        while (true) {
            try {
                int outputSize = this.inflater.inflate(output, offset, length);
                if (outputSize > 0) {
                    return outputSize;
                }
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            if (this.inflater.needsDictionary()) {
                return -1;
            }
            if (this.inflater.finished()) {
                int remainingBytes = this.inflater.getRemaining();
                if (remainingBytes > 0) {
                    this.inflater.reset();
                    this.inflater.setInput(this.inputBuffer, this.inputBufferEnd - remainingBytes, remainingBytes);
                    continue;
                }
                int bufferedBytes = this.input.read(this.inputBuffer, 0, this.inputBuffer.length);
                if (bufferedBytes < 0) {
                    return -1;
                }
                this.inflater.reset();
                this.inflater.setInput(this.inputBuffer, 0, bufferedBytes);
                this.inputBufferEnd = bufferedBytes;
                continue;
            }
            if (!this.inflater.needsInput()) continue;
            int bufferedBytes = this.input.read(this.inputBuffer, 0, this.inputBuffer.length);
            if (bufferedBytes < 0) {
                throw new EOFException("Unexpected end of input stream");
            }
            this.inflater.setInput(this.inputBuffer, 0, bufferedBytes);
            this.inputBufferEnd = bufferedBytes;
        }
    }

    @Override
    public void resetState() {
        this.inflater.reset();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.inflater.end();
            this.input.close();
        }
    }
}

