/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.io.airlift.compress.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.paimon.shade.io.airlift.compress.bzip2.CBZip2OutputStream;
import org.apache.paimon.shade.io.airlift.compress.hadoop.HadoopOutputStream;

class BZip2HadoopOutputStream
extends HadoopOutputStream {
    private final OutputStream rawOutput;
    private boolean initialized;
    private CBZip2OutputStream output;

    public BZip2HadoopOutputStream(OutputStream out) {
        this.rawOutput = Objects.requireNonNull(out, "out is null");
    }

    @Override
    public void write(int b) throws IOException {
        this.openStreamIfNecessary();
        this.output.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.openStreamIfNecessary();
        this.output.write(b, off, len);
    }

    @Override
    public void finish() throws IOException {
        if (this.output != null) {
            this.output.finish();
            this.output = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.rawOutput.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.initialized) {
                this.openStreamIfNecessary();
            }
            this.finish();
        }
        finally {
            this.rawOutput.close();
        }
    }

    private void openStreamIfNecessary() throws IOException {
        if (this.output == null) {
            this.initialized = true;
            this.rawOutput.write(new byte[]{66, 90});
            this.output = new CBZip2OutputStream(this.rawOutput);
        }
    }
}

