/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.chain;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.MetadataObjectChange;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.RoleChange;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.authorization.common.ChainedAuthorizationProperties;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.connector.authorization.BaseAuthorization;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.gravitino.utils.IsolatedClassLoader;

public class ChainedAuthorizationPlugin
implements AuthorizationPlugin {
    private List<AuthorizationPlugin> plugins = Lists.newArrayList();
    private final String metalake;

    public ChainedAuthorizationPlugin(String metalake, String catalogProvider, Map<String, String> config) {
        this.metalake = metalake;
        this.initPlugins(catalogProvider, config);
    }

    private void initPlugins(String catalogProvider, Map<String, String> properties) {
        ChainedAuthorizationProperties chainedAuthzProperties = new ChainedAuthorizationProperties(properties);
        chainedAuthzProperties.validate();
        chainedAuthzProperties.plugins().forEach(pluginName -> {
            String authzProvider = chainedAuthzProperties.getPluginProvider(pluginName);
            Map pluginConfig = chainedAuthzProperties.fetchAuthPluginProperties(pluginName);
            ArrayList libAndResourcesPaths = Lists.newArrayList();
            BaseAuthorization.buildAuthorizationPkgPath((Map)ImmutableMap.of((Object)"authorization-provider", (Object)authzProvider)).ifPresent(libAndResourcesPaths::add);
            IsolatedClassLoader classLoader = IsolatedClassLoader.buildClassLoader((List)libAndResourcesPaths);
            try {
                BaseAuthorization authorization = BaseAuthorization.createAuthorization((IsolatedClassLoader)classLoader, (String)authzProvider);
                AuthorizationPlugin authorizationPlugin = (AuthorizationPlugin)classLoader.withClassLoader(cl -> authorization.newPlugin(this.metalake, catalogProvider, pluginConfig));
                this.plugins.add(authorizationPlugin);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void close() throws IOException {
        for (AuthorizationPlugin plugin : this.plugins) {
            plugin.close();
        }
    }

    public Boolean onMetadataUpdated(MetadataObjectChange ... changes) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onMetadataUpdated(changes));
    }

    public Boolean onRoleCreated(Role role) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onRoleCreated(role));
    }

    public Boolean onRoleAcquired(Role role) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onRoleAcquired(role));
    }

    public Boolean onRoleDeleted(Role role) throws AuthorizationPluginException {
        this.onRoleUpdated(role, (RoleChange[])role.securableObjects().stream().map(securableObject -> RoleChange.removeSecurableObject((String)role.name(), (SecurableObject)securableObject)).toArray(RoleChange[]::new));
        return this.chainedAction(plugin -> plugin.onRoleDeleted(role));
    }

    public Boolean onRoleUpdated(Role role, RoleChange ... changes) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onRoleUpdated(role, changes));
    }

    public Boolean onGrantedRolesToUser(List<Role> roles, User user) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onGrantedRolesToUser(roles, user));
    }

    public Boolean onRevokedRolesFromUser(List<Role> roles, User user) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onRevokedRolesFromUser(roles, user));
    }

    public Boolean onGrantedRolesToGroup(List<Role> roles, Group group) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onGrantedRolesToGroup(roles, group));
    }

    public Boolean onRevokedRolesFromGroup(List<Role> roles, Group group) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onRevokedRolesFromGroup(roles, group));
    }

    public Boolean onUserAdded(User user) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onUserAdded(user));
    }

    public Boolean onUserRemoved(User user) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onUserRemoved(user));
    }

    public Boolean onUserAcquired(User user) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onUserAcquired(user));
    }

    public Boolean onGroupAdded(Group group) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onGroupAdded(group));
    }

    public Boolean onGroupRemoved(Group group) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onGroupRemoved(group));
    }

    public Boolean onGroupAcquired(Group group) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onGroupAcquired(group));
    }

    public Boolean onOwnerSet(MetadataObject metadataObject, Owner preOwner, Owner newOwner) throws AuthorizationPluginException {
        return this.chainedAction(plugin -> plugin.onOwnerSet(metadataObject, preOwner, newOwner));
    }

    private Boolean chainedAction(Function<AuthorizationPlugin, Boolean> action) {
        for (AuthorizationPlugin plugin : this.plugins) {
            if (action.apply(plugin).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

