/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.utils.FunctionWithIOException;

@Public
public class DeletionFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final long offset;
    private final long length;
    @Nullable
    private final Long cardinality;

    public DeletionFile(String path, long offset, long length, @Nullable Long cardinality) {
        this.path = path;
        this.offset = offset;
        this.length = length;
        this.cardinality = cardinality;
    }

    public String path() {
        return this.path;
    }

    public long offset() {
        return this.offset;
    }

    public long length() {
        return this.length;
    }

    @Nullable
    public Long cardinality() {
        return this.cardinality;
    }

    public static void serialize(DataOutputView out, @Nullable DeletionFile file) throws IOException {
        if (file == null) {
            out.write(0);
        } else {
            out.write(1);
            out.writeUTF(file.path);
            out.writeLong(file.offset);
            out.writeLong(file.length);
            out.writeLong(file.cardinality == null ? -1L : file.cardinality);
        }
    }

    public static void serializeList(DataOutputView out, @Nullable List<DeletionFile> files) throws IOException {
        if (files == null) {
            out.write(0);
        } else {
            out.write(1);
            out.writeInt(files.size());
            for (DeletionFile file : files) {
                DeletionFile.serialize(out, file);
            }
        }
    }

    @Nullable
    public static DeletionFile deserialize(DataInputView in) throws IOException {
        if (in.readByte() == 0) {
            return null;
        }
        String path = in.readUTF();
        long offset = in.readLong();
        long length = in.readLong();
        long cardinality = in.readLong();
        return new DeletionFile(path, offset, length, cardinality == -1L ? null : Long.valueOf(cardinality));
    }

    @Nullable
    public static DeletionFile deserializeV3(DataInputView in) throws IOException {
        if (in.readByte() == 0) {
            return null;
        }
        String path = in.readUTF();
        long offset = in.readLong();
        long length = in.readLong();
        return new DeletionFile(path, offset, length, null);
    }

    @Nullable
    public static List<DeletionFile> deserializeList(DataInputView in, FunctionWithIOException<DataInputView, DeletionFile> deserialize) throws IOException {
        ArrayList<Object> files = null;
        if (in.readByte() == 1) {
            int size = in.readInt();
            files = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                files.add(deserialize.apply((Object)in));
            }
        }
        return files;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletionFile that = (DeletionFile)o;
        return this.offset == that.offset && this.length == that.length && Objects.equals(this.path, that.path) && Objects.equals(this.cardinality, that.cardinality);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.offset, this.length, this.cardinality);
    }

    public String toString() {
        return "DeletionFile{path='" + this.path + '\'' + ", offset=" + this.offset + ", length=" + this.length + ", cardinality=" + this.cardinality + '}';
    }

    static Factory emptyFactory() {
        return fileName -> Optional.empty();
    }

    public static Factory factory(List<DataFileMeta> files, @Nullable List<DeletionFile> deletionFiles) {
        if (deletionFiles == null) {
            return DeletionFile.emptyFactory();
        }
        HashMap<String, DeletionFile> fileToDeletion = new HashMap<String, DeletionFile>();
        for (int i = 0; i < files.size(); ++i) {
            DeletionFile deletionFile = deletionFiles.get(i);
            if (deletionFile == null) continue;
            fileToDeletion.put(files.get(i).fileName(), deletionFile);
        }
        return fileName -> {
            DeletionFile deletionFile = (DeletionFile)fileToDeletion.get(fileName);
            return Optional.ofNullable(deletionFile);
        };
    }

    public static interface Factory {
        public Optional<DeletionFile> create(String var1) throws IOException;
    }
}

