/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.privilege;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.privilege.NoPrivilegeException;
import org.apache.paimon.privilege.PrivilegeChecker;
import org.apache.paimon.privilege.PrivilegeType;

public class PrivilegeCheckerImpl
implements PrivilegeChecker {
    private static final long serialVersionUID = 1L;
    private final String user;
    private final Map<String, Set<PrivilegeType>> privileges;

    public PrivilegeCheckerImpl(String user, Map<String, Set<PrivilegeType>> privileges) {
        this.user = user;
        this.privileges = privileges;
    }

    @Override
    public void assertCanSelect(Identifier identifier) {
        if (!this.check(identifier.getFullName(), PrivilegeType.SELECT)) {
            throw new NoPrivilegeException(this.user, "table", identifier.getFullName(), PrivilegeType.SELECT);
        }
    }

    @Override
    public void assertCanInsert(Identifier identifier) {
        if (!this.check(identifier.getFullName(), PrivilegeType.INSERT)) {
            throw new NoPrivilegeException(this.user, "table", identifier.getFullName(), PrivilegeType.INSERT);
        }
    }

    @Override
    public void assertCanAlterTable(Identifier identifier) {
        if (!this.check(identifier.getFullName(), PrivilegeType.ALTER_TABLE)) {
            throw new NoPrivilegeException(this.user, "table", identifier.getFullName(), PrivilegeType.ALTER_TABLE);
        }
    }

    @Override
    public void assertCanDropTable(Identifier identifier) {
        if (!this.check(identifier.getFullName(), PrivilegeType.DROP_TABLE)) {
            throw new NoPrivilegeException(this.user, "table", identifier.getFullName(), PrivilegeType.DROP_TABLE);
        }
    }

    @Override
    public void assertCanCreateTable(String databaseName) {
        if (!this.check(databaseName, PrivilegeType.CREATE_TABLE)) {
            throw new NoPrivilegeException(this.user, "database", databaseName, PrivilegeType.CREATE_TABLE);
        }
    }

    @Override
    public void assertCanDropDatabase(String databaseName) {
        if (!this.check(databaseName, PrivilegeType.DROP_DATABASE)) {
            throw new NoPrivilegeException(this.user, "database", databaseName, PrivilegeType.DROP_DATABASE);
        }
    }

    @Override
    public void assertCanAlterDatabase(String databaseName) {
        if (!this.check(databaseName, PrivilegeType.ALTER_DATABASE)) {
            throw new NoPrivilegeException(this.user, "database", databaseName, PrivilegeType.ALTER_DATABASE);
        }
    }

    @Override
    public void assertCanCreateDatabase() {
        if (!this.check("", PrivilegeType.CREATE_DATABASE)) {
            throw new NoPrivilegeException(this.user, "catalog", "", PrivilegeType.DROP_DATABASE);
        }
    }

    @Override
    public void assertCanCreateUser() {
        this.assertHasAdmin();
    }

    @Override
    public void assertCanDropUser() {
        this.assertHasAdmin();
    }

    @Override
    public void assertCanGrant(String identifier, PrivilegeType privilege) {
        this.assertHasAdmin();
    }

    @Override
    public void assertCanRevoke() {
        this.assertHasAdmin();
    }

    private void assertHasAdmin() {
        if (!this.check("", PrivilegeType.ADMIN)) {
            throw new NoPrivilegeException(this.user, "catalog", "", PrivilegeType.ADMIN);
        }
    }

    private boolean check(String identifier, PrivilegeType privilege) {
        Set<PrivilegeType> set = this.privileges.get(identifier);
        if (set != null && set.contains((Object)privilege)) {
            return true;
        }
        if (identifier.isEmpty()) {
            return false;
        }
        return this.check(identifier.substring(0, Math.max(identifier.lastIndexOf(46), 0)), privilege);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeCheckerImpl that = (PrivilegeCheckerImpl)o;
        return Objects.equals(this.user, that.user) && Objects.equals(this.privileges, that.privileges);
    }
}

