/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFileMerger {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFileMerger.class);

    public static List<ManifestFileMeta> merge(List<ManifestFileMeta> input, ManifestFile manifestFile, long suggestedMetaSize, int suggestedMinMetaCount, long manifestFullCompactionSize, RowType partitionType, @Nullable Integer manifestReadParallelism) {
        ArrayList<ManifestFileMeta> newFilesForAbort = new ArrayList<ManifestFileMeta>();
        try {
            Optional<List<ManifestFileMeta>> fullCompacted = ManifestFileMerger.tryFullCompaction(input, newFilesForAbort, manifestFile, suggestedMetaSize, manifestFullCompactionSize, partitionType, manifestReadParallelism);
            return fullCompacted.orElseGet(() -> ManifestFileMerger.tryMinorCompaction(input, newFilesForAbort, manifestFile, suggestedMetaSize, suggestedMinMetaCount, manifestReadParallelism));
        }
        catch (Throwable e) {
            for (ManifestFileMeta manifest : newFilesForAbort) {
                manifestFile.delete(manifest.fileName());
            }
            throw new RuntimeException(e);
        }
    }

    private static List<ManifestFileMeta> tryMinorCompaction(List<ManifestFileMeta> input, List<ManifestFileMeta> newFilesForAbort, ManifestFile manifestFile, long suggestedMetaSize, int suggestedMinMetaCount, @Nullable Integer manifestReadParallelism) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        ArrayList<ManifestFileMeta> candidates = new ArrayList<ManifestFileMeta>();
        long totalSize = 0L;
        for (ManifestFileMeta manifest : input) {
            candidates.add(manifest);
            if ((totalSize += manifest.fileSize()) < suggestedMetaSize) continue;
            ManifestFileMerger.mergeCandidates(candidates, manifestFile, result, newFilesForAbort, manifestReadParallelism);
            candidates.clear();
            totalSize = 0L;
        }
        if (candidates.size() >= suggestedMinMetaCount) {
            ManifestFileMerger.mergeCandidates(candidates, manifestFile, result, newFilesForAbort, manifestReadParallelism);
        } else {
            result.addAll(candidates);
        }
        return result;
    }

    private static void mergeCandidates(List<ManifestFileMeta> candidates, ManifestFile manifestFile, List<ManifestFileMeta> result, List<ManifestFileMeta> newMetas, @Nullable Integer manifestReadParallelism) {
        if (candidates.size() == 1) {
            result.add(candidates.get(0));
            return;
        }
        LinkedHashMap<FileEntry.Identifier, ManifestEntry> map = new LinkedHashMap<FileEntry.Identifier, ManifestEntry>();
        FileEntry.mergeEntries(manifestFile, candidates, map, manifestReadParallelism);
        if (!map.isEmpty()) {
            List<ManifestFileMeta> merged = manifestFile.write(new ArrayList<ManifestEntry>(map.values()));
            result.addAll(merged);
            newMetas.addAll(merged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<List<ManifestFileMeta>> tryFullCompaction(List<ManifestFileMeta> inputs, List<ManifestFileMeta> newFilesForAbort, ManifestFile manifestFile, long suggestedMetaSize, long sizeTrigger, RowType partitionType, @Nullable Integer manifestReadParallelism) throws Exception {
        PartitionPredicate predicate;
        Preconditions.checkArgument((sizeTrigger > 0L ? 1 : 0) != 0, (Object)"Manifest full compaction size trigger cannot be zero.");
        Filter mustChange = file -> file.numDeletedFiles() > 0L || file.fileSize() < suggestedMetaSize;
        long totalManifestSize = 0L;
        long deltaDeleteFileNum = 0L;
        long totalDeltaFileSize = 0L;
        for (ManifestFileMeta file2 : inputs) {
            totalManifestSize += file2.fileSize();
            if (!mustChange.test((Object)file2)) continue;
            totalDeltaFileSize += file2.fileSize();
            deltaDeleteFileNum += file2.numDeletedFiles();
        }
        if (totalDeltaFileSize < sizeTrigger) {
            return Optional.empty();
        }
        LOG.info("Start Manifest File Full Compaction: totalManifestSize: {}, deltaDeleteFileNum {}, totalDeltaFileSize {}", new Object[]{totalManifestSize, deltaDeleteFileNum, totalDeltaFileSize});
        Set<FileEntry.Identifier> deleteEntries = FileEntry.readDeletedEntries(manifestFile, inputs, manifestReadParallelism);
        if (deleteEntries.isEmpty()) {
            predicate = PartitionPredicate.alwaysFalse();
        } else if (partitionType.getFieldCount() > 0) {
            Set<BinaryRow> deletePartitions = ManifestFileMerger.computeDeletePartitions(deleteEntries);
            predicate = PartitionPredicate.fromMultiple(partitionType, deletePartitions);
        } else {
            predicate = PartitionPredicate.alwaysTrue();
        }
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        LinkedList<ManifestFileMeta> toBeMerged = new LinkedList<ManifestFileMeta>(inputs);
        if (predicate != null) {
            Iterator iterator = toBeMerged.iterator();
            while (iterator.hasNext()) {
                ManifestFileMeta file3 = (ManifestFileMeta)iterator.next();
                if (mustChange.test((Object)file3) || predicate.test(file3.numAddedFiles() + file3.numDeletedFiles(), (InternalRow)file3.partitionStats().minValues(), (InternalRow)file3.partitionStats().maxValues(), (InternalArray)file3.partitionStats().nullCounts())) continue;
                iterator.remove();
                result.add(file3);
            }
        }
        if (toBeMerged.size() <= 1) {
            return Optional.empty();
        }
        RollingFileWriter<ManifestEntry, ManifestFileMeta> writer = manifestFile.createRollingWriter();
        Exception exception = null;
        try {
            for (ManifestFileMeta file4 : toBeMerged) {
                ArrayList<ManifestEntry> entries = new ArrayList<ManifestEntry>();
                boolean requireChange = mustChange.test((Object)file4);
                for (ManifestEntry entry : manifestFile.read(file4.fileName(), file4.fileSize())) {
                    if (entry.kind() == FileKind.DELETE) continue;
                    if (deleteEntries.contains(entry.identifier())) {
                        requireChange = true;
                        continue;
                    }
                    entries.add(entry);
                }
                if (requireChange) {
                    writer.write((ManifestEntry)((Object)entries));
                    continue;
                }
                result.add(file4);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                writer.abort();
                throw exception;
            }
            writer.close();
        }
        Object merged = writer.result();
        result.addAll((Collection<ManifestFileMeta>)merged);
        newFilesForAbort.addAll((Collection<ManifestFileMeta>)merged);
        return Optional.of(result);
    }

    private static Set<BinaryRow> computeDeletePartitions(Set<FileEntry.Identifier> deleteEntries) {
        HashSet<BinaryRow> partitions = new HashSet<BinaryRow>();
        for (FileEntry.Identifier identifier : deleteEntries) {
            partitions.add(identifier.partition);
        }
        return partitions;
    }
}

