/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.metastore;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.paimon.table.PartitionHandler;
import org.apache.paimon.table.sink.TagCallback;

public class AddPartitionTagCallback
implements TagCallback {
    private final PartitionHandler partitionHandler;
    private final String partitionField;

    public AddPartitionTagCallback(PartitionHandler partitionHandler, String partitionField) {
        this.partitionHandler = partitionHandler;
        this.partitionField = partitionField;
    }

    @Override
    public void notifyCreation(String tagName) {
        LinkedHashMap<String, String> partitionSpec = new LinkedHashMap<String, String>();
        partitionSpec.put(this.partitionField, tagName);
        try {
            this.partitionHandler.createPartitions(Collections.singletonList(partitionSpec));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void notifyDeletion(String tagName) {
        LinkedHashMap<String, String> partitionSpec = new LinkedHashMap<String, String>();
        partitionSpec.put(this.partitionField, tagName);
        try {
            this.partitionHandler.dropPartitions(Collections.singletonList(partitionSpec));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.partitionHandler.close();
    }
}

