/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.crosspartition;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.utils.Filter;

public class BucketAssigner {
    private final Map<BinaryRow, TreeMap<Integer, Integer>> stats = new HashMap<BinaryRow, TreeMap<Integer, Integer>>();

    public void bootstrapBucket(BinaryRow part, int bucket) {
        TreeMap<Integer, Integer> bucketMap = this.bucketMap(part);
        Integer count = bucketMap.get(bucket);
        if (count == null) {
            count = 0;
        }
        bucketMap.put(bucket, count + 1);
    }

    public int assignBucket(BinaryRow part, Filter<Integer> filter, int maxCount) {
        TreeMap<Integer, Integer> bucketMap = this.bucketMap(part);
        for (Map.Entry<Integer, Integer> entry : bucketMap.entrySet()) {
            int bucket = entry.getKey();
            int count = entry.getValue();
            if (!filter.test((Object)bucket) || count >= maxCount) continue;
            bucketMap.put(bucket, count + 1);
            return bucket;
        }
        int i = 0;
        while (true) {
            if (filter.test((Object)i) && !bucketMap.containsKey(i)) {
                bucketMap.put(i, 1);
                return i;
            }
            ++i;
        }
    }

    public void decrement(BinaryRow part, int bucket) {
        this.bucketMap(part).compute(bucket, (k, v) -> v == null ? 0 : v - 1);
    }

    private TreeMap<Integer, Integer> bucketMap(BinaryRow part) {
        TreeMap<Integer, Integer> map = this.stats.get(part);
        if (map == null) {
            map = new TreeMap();
            this.stats.put(part.copy(), map);
        }
        return map;
    }
}

