/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class FutureUtils {
    public static <T> CompletableFuture<T> completedExceptionally(Throwable cause) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(cause);
        return result;
    }

    public static <T> void forward(CompletableFuture<T> source, CompletableFuture<T> target) {
        source.whenComplete((BiConsumer)FutureUtils.forwardTo(target));
    }

    private static <T> BiConsumer<T, Throwable> forwardTo(CompletableFuture<T> target) {
        return (value, throwable) -> FutureUtils.doForward(value, throwable, target);
    }

    public static <T> void doForward(@Nullable T value, @Nullable Throwable throwable, CompletableFuture<T> target) {
        if (throwable != null) {
            target.completeExceptionally(throwable);
        } else {
            target.complete(value);
        }
    }
}

