/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;

public class DecimalUtils {
    static final int MAX_COMPACT_PRECISION = 18;
    static final long[] POW10 = new long[19];

    public static double doubleValue(Decimal decimal) {
        if (decimal.isCompact()) {
            return (double)decimal.toUnscaledLong() / (double)POW10[decimal.scale()];
        }
        return decimal.toBigDecimal().doubleValue();
    }

    public static Decimal add(Decimal v1, Decimal v2, int precision, int scale) {
        if (v1.isCompact() && v2.isCompact() && v1.scale() == v2.scale() && Decimal.isCompact(precision)) {
            assert (scale == v1.scale());
            try {
                long ls = Math.addExact(v1.toUnscaledLong(), v2.toUnscaledLong());
                return Decimal.fromUnscaledLong(ls, precision, scale);
            }
            catch (ArithmeticException ls) {
                // empty catch block
            }
        }
        BigDecimal bd = v1.toBigDecimal().add(v2.toBigDecimal());
        return Decimal.fromBigDecimal(bd, precision, scale);
    }

    public static Decimal subtract(Decimal v1, Decimal v2, int precision, int scale) {
        if (v1.isCompact() && v2.isCompact() && v1.scale() == v2.scale() && Decimal.isCompact(precision)) {
            assert (scale == v1.scale());
            try {
                long ls = Math.subtractExact(v1.toUnscaledLong(), v2.toUnscaledLong());
                return Decimal.fromUnscaledLong(ls, precision, scale);
            }
            catch (ArithmeticException ls) {
                // empty catch block
            }
        }
        BigDecimal bd = v1.toBigDecimal().subtract(v2.toBigDecimal());
        return Decimal.fromBigDecimal(bd, precision, scale);
    }

    public static long castToIntegral(Decimal dec) {
        BigDecimal bd = dec.toBigDecimal();
        bd = bd.setScale(0, RoundingMode.DOWN);
        return bd.longValue();
    }

    public static Decimal castToDecimal(Decimal dec, int precision, int scale) {
        return Decimal.fromBigDecimal(dec.toBigDecimal(), precision, scale);
    }

    public static Decimal castFrom(Decimal dec, int precision, int scale) {
        return Decimal.fromBigDecimal(dec.toBigDecimal(), precision, scale);
    }

    public static Decimal castFrom(String string, int precision, int scale) {
        return Decimal.fromBigDecimal(new BigDecimal(string), precision, scale);
    }

    public static Decimal castFrom(BinaryString string, int precision, int scale) {
        return DecimalUtils.castFrom(string.toString(), precision, scale);
    }

    public static Decimal castFrom(double val, int p, int s) {
        return Decimal.fromBigDecimal(BigDecimal.valueOf(val), p, s);
    }

    public static Decimal castFrom(long val, int p, int s) {
        return Decimal.fromBigDecimal(BigDecimal.valueOf(val), p, s);
    }

    public static boolean castToBoolean(Decimal dec) {
        return dec.toBigDecimal().compareTo(BigDecimal.ZERO) != 0;
    }

    static {
        DecimalUtils.POW10[0] = 1L;
        for (int i = 1; i < POW10.length; ++i) {
            DecimalUtils.POW10[i] = 10L * POW10[i - 1];
        }
    }
}

