/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.predicate.And;
import org.apache.paimon.predicate.CompoundPredicate;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateVisitor;

public class PredicateProjectionConverter
implements PredicateVisitor<Optional<Predicate>> {
    private final Map<Integer, Integer> reversed = new HashMap<Integer, Integer>();

    public PredicateProjectionConverter(int[] projection) {
        for (int i = 0; i < projection.length; ++i) {
            this.reversed.put(projection[i], i);
        }
    }

    @Override
    public Optional<Predicate> visit(LeafPredicate predicate) {
        int index = predicate.index();
        Integer adjusted = this.reversed.get(index);
        if (adjusted == null) {
            return Optional.empty();
        }
        return Optional.of(predicate.copyWithNewIndex(adjusted));
    }

    @Override
    public Optional<Predicate> visit(CompoundPredicate predicate) {
        ArrayList<Predicate> converted = new ArrayList<Predicate>();
        boolean isAnd = predicate.function() instanceof And;
        for (Predicate child : predicate.children()) {
            Optional<Predicate> optional = child.visit(this);
            if (optional.isPresent()) {
                converted.add(optional.get());
                continue;
            }
            if (isAnd) continue;
            return Optional.empty();
        }
        return Optional.of(new CompoundPredicate(predicate.function(), converted));
    }
}

