/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.BlockCompressionType;
import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.compression.ZstdBlockCompressor;
import org.apache.paimon.compression.ZstdBlockDecompressor;

public class ZstdBlockCompressionFactory
implements BlockCompressionFactory {
    private final int compressLevel;

    public ZstdBlockCompressionFactory(int compressLevel) {
        this.compressLevel = compressLevel;
    }

    @Override
    public BlockCompressionType getCompressionType() {
        return BlockCompressionType.ZSTD;
    }

    @Override
    public BlockCompressor getCompressor() {
        return new ZstdBlockCompressor(this.compressLevel);
    }

    @Override
    public BlockDecompressor getDecompressor() {
        return new ZstdBlockDecompressor();
    }
}

