/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen.codesplit;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.paimon.codegen.codesplit.AddBoolBeforeReturnRewriter;
import org.apache.paimon.codegen.codesplit.CodeRewriter;
import org.apache.paimon.codegen.codesplit.CodeSplitUtil;
import org.apache.paimon.codegen.codesplit.JavaLexer;
import org.apache.paimon.codegen.codesplit.JavaParser;
import org.apache.paimon.codegen.codesplit.JavaParserBaseVisitor;
import org.apache.paimon.shade.org.antlr.v4.runtime.CharStreams;
import org.apache.paimon.shade.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.paimon.shade.org.antlr.v4.runtime.TokenStreamRewriter;
import org.apache.paimon.shade.org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.paimon.shade.org.antlr.v4.runtime.atn.PredictionMode;

public class FunctionSplitter
implements CodeRewriter {
    private String code;
    private final int maxMethodLength;

    public FunctionSplitter(String code, int maxMethodLength) {
        this.code = code;
        this.maxMethodLength = maxMethodLength;
    }

    @Override
    public String rewrite() {
        AddBoolBeforeReturnRewriter boolRewriter = new AddBoolBeforeReturnRewriter(this.code, this.maxMethodLength);
        this.code = boolRewriter.rewrite();
        FunctionSplitVisitor visitor = new FunctionSplitVisitor(boolRewriter.getBoolVarNames());
        JavaParser javaParser = new JavaParser(visitor.tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        visitor.visit(javaParser.compilationUnit());
        return visitor.rewriter.getText();
    }

    private class FunctionSplitVisitor
    extends JavaParserBaseVisitor<Void> {
        private final CommonTokenStream tokenStream;
        private final TokenStreamRewriter rewriter;
        private final List<Map<String, String>> boolVarNames;
        private int classCount;

        private FunctionSplitVisitor(List<Map<String, String>> boolVarNames) {
            this.tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(FunctionSplitter.this.code)));
            this.rewriter = new TokenStreamRewriter(this.tokenStream);
            this.boolVarNames = boolVarNames;
            this.classCount = -1;
        }

        @Override
        public Void visitClassBody(JavaParser.ClassBodyContext ctx) {
            ++this.classCount;
            return (Void)this.visitChildren(ctx);
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            String hasReturnedVarName;
            if (!"void".equals(ctx.typeTypeOrVoid().getText())) {
                return null;
            }
            long methodBodyLength = CodeSplitUtil.getContextTextLength(ctx.methodBody().block());
            if (methodBodyLength < (long)FunctionSplitter.this.maxMethodLength) {
                return null;
            }
            if (ctx.methodBody().block().blockStatement() == null || ctx.methodBody().block().blockStatement().size() <= 1) {
                return null;
            }
            ArrayList<String> splitFuncBodies = new ArrayList<String>();
            ArrayList<JavaParser.BlockStatementContext> blockStatementContexts = new ArrayList<JavaParser.BlockStatementContext>();
            final LinkedHashSet declarations = new LinkedHashSet();
            new JavaParserBaseVisitor<Void>(){

                @Override
                public Void visitFormalParameter(JavaParser.FormalParameterContext ctx) {
                    declarations.add(ctx.variableDeclaratorId().getText());
                    return null;
                }
            }.visit(ctx);
            String type = CodeSplitUtil.getContextString(ctx.typeTypeOrVoid());
            String functionName = ctx.IDENTIFIER().getText();
            String parameters = CodeSplitUtil.getContextString(ctx.formalParameters());
            for (JavaParser.BlockStatementContext blockStatementContext : ctx.methodBody().block().blockStatement()) {
                blockStatementContexts.add(blockStatementContext);
                splitFuncBodies.add(CodeSplitUtil.getContextString(blockStatementContext));
            }
            List<String> mergedCodeBlocks = this.getMergedCodeBlocks(splitFuncBodies);
            ArrayList<String> newSplitMethods = new ArrayList<String>();
            ArrayList<String> newSplitMethodCalls = new ArrayList<String>();
            String methodQualifier = "";
            if (ctx.THROWS() != null) {
                methodQualifier = " throws " + CodeSplitUtil.getContextString(ctx.qualifiedNameList());
            }
            if ((hasReturnedVarName = this.boolVarNames.get(this.classCount).get(functionName + parameters)) != null) {
                this.rewriter.insertAfter(ctx.methodBody().block().start, (Object)String.format("\n%s = false;", hasReturnedVarName));
            }
            for (String methodBody : mergedCodeBlocks) {
                long counter = CodeSplitUtil.getCounter().getAndIncrement();
                String splitMethodDef = type + " " + functionName + "_split" + counter + parameters + methodQualifier;
                String newSplitMethod = splitMethodDef + " {\n" + methodBody + "\n}\n";
                String newSplitMethodCall = functionName + "_split" + counter + "(" + String.join((CharSequence)", ", declarations) + ");\n";
                if (hasReturnedVarName != null && newSplitMethod.contains(hasReturnedVarName)) {
                    newSplitMethodCall = newSplitMethodCall + String.format("if (%s) { return; }\n", hasReturnedVarName);
                }
                newSplitMethods.add(newSplitMethod);
                newSplitMethodCalls.add(newSplitMethodCall);
            }
            for (int i = 0; i < blockStatementContexts.size(); ++i) {
                if (i < newSplitMethods.size()) {
                    this.rewriter.replace(((JavaParser.BlockStatementContext)blockStatementContexts.get((int)i)).start, ((JavaParser.BlockStatementContext)blockStatementContexts.get((int)i)).stop, newSplitMethodCalls.get(i));
                    this.rewriter.insertAfter(ctx.getParent().stop, (Object)("\n" + (String)newSplitMethods.get(i)));
                    continue;
                }
                this.rewriter.delete(((JavaParser.BlockStatementContext)blockStatementContexts.get((int)i)).start, ((JavaParser.BlockStatementContext)blockStatementContexts.get((int)i)).stop);
            }
            return null;
        }

        private List<String> getMergedCodeBlocks(List<String> codeBlock) {
            ArrayList<String> mergedCodeBlocks = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            codeBlock.forEach(code -> {
                if (sb.length() + code.length() + 1 <= FunctionSplitter.this.maxMethodLength) {
                    sb.append("\n").append((String)code);
                } else {
                    if (sb.length() > 0) {
                        mergedCodeBlocks.add(sb.toString());
                        sb.delete(0, sb.length());
                    }
                    sb.append((String)code);
                }
            });
            if (sb.length() > 0) {
                mergedCodeBlocks.add(sb.toString());
            }
            return mergedCodeBlocks;
        }
    }
}

