/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.utils.DecimalUtils;

class NumericPrimitiveToDecimalCastRule
extends AbstractCastRule<Number, Decimal> {
    static final NumericPrimitiveToDecimalCastRule INSTANCE = new NumericPrimitiveToDecimalCastRule();

    private NumericPrimitiveToDecimalCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.INTEGER_NUMERIC).input(DataTypeFamily.APPROXIMATE_NUMERIC).target(DataTypeRoot.DECIMAL).build());
    }

    @Override
    public CastExecutor<Number, Decimal> create(DataType inputType, DataType targetType) {
        DecimalType decimalType = (DecimalType)targetType;
        if (inputType.is(DataTypeFamily.INTEGER_NUMERIC)) {
            return value -> DecimalUtils.castFrom(value.longValue(), decimalType.getPrecision(), decimalType.getScale());
        }
        return value -> DecimalUtils.castFrom(value.doubleValue(), decimalType.getPrecision(), decimalType.getScale());
    }
}

