/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.VarCharType;

public class MapToStringCastRule
extends AbstractCastRule<InternalMap, BinaryString> {
    static final MapToStringCastRule INSTANCE = new MapToStringCastRule();

    private MapToStringCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.MAP).target(DataTypeFamily.CHARACTER_STRING).build());
    }

    @Override
    public CastExecutor<InternalMap, BinaryString> create(DataType inputType, DataType targetType) {
        MapType mapType = (MapType)inputType;
        InternalArray.ElementGetter keyGetter = InternalArray.createElementGetter(mapType.getKeyType());
        InternalArray.ElementGetter valueGetter = InternalArray.createElementGetter(mapType.getValueType());
        CastExecutor<?, ?> keyCastExecutor = CastExecutors.resolve(mapType.getKeyType(), (DataType)VarCharType.STRING_TYPE);
        CastExecutor<?, ?> valueCastExecutor = CastExecutors.resolve(mapType.getValueType(), (DataType)VarCharType.STRING_TYPE);
        return mapData -> {
            InternalArray keyArray = mapData.keyArray();
            InternalArray valueArray = mapData.valueArray();
            int size = mapData.size();
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (int i = 0; i < size; ++i) {
                Object k = keyGetter.getElementOrNull(keyArray, i);
                if (k == null) {
                    sb.append("null");
                } else {
                    sb.append(keyCastExecutor.cast(k));
                }
                sb.append(" -> ");
                Object v = valueGetter.getElementOrNull(valueArray, i);
                if (v == null) {
                    sb.append("null");
                } else {
                    sb.append(valueCastExecutor.cast(v));
                }
                if (i == size - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            return BinaryString.fromString(sb.toString());
        };
    }
}

