/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.TableCommand;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;

public class TableSortOrder
extends TableCommand {
    protected final String schema;
    protected final String table;

    public TableSortOrder(CommandContext context, String metalake, String catalog, String schema, String table) {
        super(context, metalake, catalog);
        this.schema = schema;
        this.table = table;
    }

    @Override
    public void handle() {
        SortOrder[] sortOrders = new SortOrder[]{};
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.table);
            sortOrders = this.tableCatalog().loadTable(name).sortOrder();
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        for (SortOrder sortOrder : sortOrders) {
            String result = String.format("%s,%s,%s", new Object[]{sortOrder.expression(), sortOrder.direction(), sortOrder.nullOrdering()});
            this.printResults(result);
        }
    }
}

