/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.ModelVersionChange;

public class SetModelVersionProperty
extends Command {
    private final String metalake;
    private final String catalog;
    private final String schema;
    private final String model;
    private final Integer version;
    private final String alias;
    private final String property;
    private final String value;

    public SetModelVersionProperty(CommandContext context, String metalake, String catalog, String schema, String model, Integer version, String alias, String property, String value) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.model = model;
        this.version = version;
        this.alias = alias;
        this.property = property;
        this.value = value;
    }

    @Override
    public void handle() {
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.model);
            GravitinoClient client = this.buildClient(this.metalake);
            ModelVersionChange change = ModelVersionChange.setProperty(this.property, this.value);
            if (this.version != null) {
                client.loadCatalog(this.catalog).asModelCatalog().alterModelVersion(name, this.version, change);
            } else {
                client.loadCatalog(this.catalog).asModelCatalog().alterModelVersion(name, this.alias, change);
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchModelException err) {
            this.exitWithError("Unknown model name.");
        }
        catch (NoSuchModelVersionException err) {
            this.exitWithError("Unknown model version.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (this.alias != null) {
            this.printInformation(this.model + " version " + this.alias + " property set.");
        } else {
            this.printInformation(this.model + " version " + this.version + " property set.");
        }
    }

    @Override
    public Command validate() {
        this.validatePropertyAndValue(this.property, this.value);
        return super.validate();
    }
}

