/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.tag.Tag;

public class ListAllTags
extends Command {
    protected final String metalake;

    public ListAllTags(CommandContext context, String metalake) {
        super(context);
        this.metalake = metalake;
    }

    @Override
    public void handle() {
        Tag[] tags = new Tag[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            tags = client.listTagsInfo();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (tags.length == 0) {
            this.printInformation("No tags exist.");
        } else {
            this.printResults(tags);
        }
    }
}

