/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.List;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class GroupDetails
extends Command {
    protected final String metalake;
    protected final String group;

    public GroupDetails(CommandContext context, String metalake, String group) {
        super(context);
        this.metalake = metalake;
        this.group = group;
    }

    @Override
    public void handle() {
        List<String> roles = null;
        Group groupObject = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            groupObject = client.getGroup(this.group);
            roles = groupObject.roles();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchGroupException err) {
            this.exitWithError("Unknown group.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (roles == null || roles.isEmpty()) {
            this.printInformation("The group has no roles.");
        } else {
            this.printResults(groupObject);
        }
    }
}

