/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.AuditCommand;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class GroupAudit
extends AuditCommand {
    protected final String metalake;
    protected final String group;

    public GroupAudit(CommandContext context, String metalake, String group) {
        super(context);
        this.metalake = metalake;
        this.group = group;
    }

    @Override
    public void handle() {
        Group result = null;
        try (GravitinoClient client = this.buildClient(this.metalake);){
            result = client.getGroup(this.group);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchGroupException err) {
            this.exitWithError("Unknown group.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (result != null) {
            this.displayAuditInfo(result.auditInfo());
        }
    }
}

