/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.List;
import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.ReadTableCSV;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Column;

public class CreateTable
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String table;
    protected final String columnFile;
    protected final String comment;

    public CreateTable(CommandContext context, String metalake, String catalog, String schema, String table, String columnFile, String comment) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.columnFile = columnFile;
        this.comment = comment;
    }

    @Override
    public void handle() {
        NameIdentifier tableName = null;
        GravitinoClient client = null;
        ReadTableCSV readTableCSV = new ReadTableCSV();
        Column[] columns = new Column[]{};
        try {
            tableName = NameIdentifier.of(this.schema, this.table);
            client = this.buildClient(this.metalake);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError("Error initializing client or table name: " + exp.getMessage());
        }
        try {
            Map<String, List<String>> tableData = readTableCSV.parse(this.columnFile);
            columns = readTableCSV.columns(tableData);
        }
        catch (Exception exp) {
            this.exitWithError("Error reading or parsing column file: " + exp.getMessage());
        }
        try {
            client.loadCatalog(this.catalog).asTableCatalog().createTable(tableName, columns, this.comment, null);
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (TableAlreadyExistsException err) {
            this.exitWithError("Table already exists.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.table + " created");
    }

    @Override
    public Command validate() {
        if (this.columnFile == null) {
            this.exitWithError("Missing --columnfile option.");
        }
        return super.validate();
    }
}

