/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.fileset;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.UserPrincipal;
import org.apache.gravitino.audit.CallerContext;
import org.apache.gravitino.catalog.FilesetFileOps;
import org.apache.gravitino.catalog.fileset.FilesetCatalogOperations;
import org.apache.gravitino.catalog.fileset.authentication.UserContext;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.connector.credential.PathContext;
import org.apache.gravitino.connector.credential.SupportsPathBasedCredentials;
import org.apache.gravitino.credential.CredentialUtils;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchLocationNameException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.file.FileInfo;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetCatalog;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.utils.ClassLoaderResourceCleanerUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureFilesetCatalogOperations
implements CatalogOperations,
SupportsSchemas,
FilesetCatalog,
FilesetFileOps,
SupportsPathBasedCredentials {
    public static final Logger LOG = LoggerFactory.getLogger(SecureFilesetCatalogOperations.class);
    private final FilesetCatalogOperations filesetCatalogOperations;
    public static final String GRAVITINO_KEYTAB_FORMAT = "keytabs/gravitino-%s";
    private UserContext catalogUserContext;
    private Map<String, String> catalogProperties;

    public SecureFilesetCatalogOperations() {
        this.filesetCatalogOperations = new FilesetCatalogOperations();
    }

    public SecureFilesetCatalogOperations(EntityStore store) {
        this.filesetCatalogOperations = new FilesetCatalogOperations(store);
    }

    public void initialize(Map<String, String> config, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        this.filesetCatalogOperations.initialize(config, info, propertiesMetadata);
        this.catalogUserContext = UserContext.getUserContext(NameIdentifier.of((Namespace)info.namespace(), (String)info.name()), config, this.filesetCatalogOperations.getHadoopConf(), info);
        this.catalogProperties = info.properties();
    }

    @VisibleForTesting
    public FilesetCatalogOperations getBaseFilesetCatalogOperations() {
        return this.filesetCatalogOperations;
    }

    public Fileset createMultipleLocationFileset(NameIdentifier ident, String comment, Fileset.Type type, Map<String, String> storageLocations, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        String apiUser = PrincipalUtils.getCurrentUserName();
        UserContext userContext = UserContext.getUserContext(ident, properties, null, this.filesetCatalogOperations.getCatalogInfo());
        return userContext.doAs(() -> {
            try {
                this.setUser(apiUser);
                Fileset fileset = this.filesetCatalogOperations.createMultipleLocationFileset(ident, comment, type, storageLocations, properties);
                return fileset;
            }
            finally {
                this.unsetUser(apiUser);
            }
        }, ident);
    }

    public boolean dropFileset(NameIdentifier ident) {
        FilesetEntity filesetEntity;
        try {
            filesetEntity = (FilesetEntity)this.filesetCatalogOperations.store().get(ident, Entity.EntityType.FILESET, FilesetEntity.class);
        }
        catch (NoSuchEntityException e) {
            LOG.warn("Fileset {} does not exist", (Object)ident);
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete fileset " + String.valueOf(ident), ioe);
        }
        UserContext userContext = UserContext.getUserContext(ident, filesetEntity.properties(), null, this.filesetCatalogOperations.getCatalogInfo());
        boolean r = userContext.doAs(() -> this.filesetCatalogOperations.dropFileset(ident), ident);
        UserContext.clearUserContext(ident);
        return r;
    }

    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        String apiUser = PrincipalUtils.getCurrentUserName();
        UserContext userContext = UserContext.getUserContext(ident, properties, null, this.filesetCatalogOperations.getCatalogInfo());
        return userContext.doAs(() -> {
            try {
                this.setUser(apiUser);
                Schema schema = this.filesetCatalogOperations.createSchema(ident, comment, properties);
                return schema;
            }
            finally {
                this.unsetUser(apiUser);
            }
        }, ident);
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        try {
            SchemaEntity schemaEntity = (SchemaEntity)this.filesetCatalogOperations.store().get(ident, Entity.EntityType.SCHEMA, SchemaEntity.class);
            Map<String, String> properties = Optional.ofNullable(schemaEntity.properties()).orElse(Collections.emptyMap());
            UserContext userContext = UserContext.getUserContext(ident, properties, null, this.filesetCatalogOperations.getCatalogInfo());
            boolean r = userContext.doAs(() -> this.filesetCatalogOperations.dropSchema(ident, cascade), ident);
            UserContext.clearUserContext(ident);
            return r;
        }
        catch (NoSuchEntityException e) {
            LOG.warn("Schema {} does not exist", (Object)ident);
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete schema " + String.valueOf(ident), ioe);
        }
    }

    public Fileset alterFileset(NameIdentifier ident, FilesetChange ... changes) throws NoSuchFilesetException, IllegalArgumentException {
        Fileset fileset = this.filesetCatalogOperations.alterFileset(ident, changes);
        String finalName = ident.name();
        for (FilesetChange change : changes) {
            if (!(change instanceof FilesetChange.RenameFileset)) continue;
            finalName = ((FilesetChange.RenameFileset)change).getNewName();
        }
        if (!ident.name().equals(finalName)) {
            UserContext.clearUserContext(NameIdentifier.of((Namespace)ident.namespace(), (String)finalName));
        }
        return fileset;
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        return this.filesetCatalogOperations.listSchemas(namespace);
    }

    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        return this.filesetCatalogOperations.loadSchema(ident);
    }

    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        return this.filesetCatalogOperations.alterSchema(ident, changes);
    }

    public NameIdentifier[] listFilesets(Namespace namespace) throws NoSuchSchemaException {
        return this.filesetCatalogOperations.listFilesets(namespace);
    }

    public FileInfo[] listFiles(NameIdentifier ident, String locationName, String subPath) throws NoSuchFilesetException, IOException {
        return this.filesetCatalogOperations.listFiles(ident, locationName, subPath);
    }

    public Fileset loadFileset(NameIdentifier ident) throws NoSuchFilesetException {
        return this.filesetCatalogOperations.loadFileset(ident);
    }

    public String getFileLocation(NameIdentifier ident, String subPath, String locationName) throws NoSuchFilesetException, NoSuchLocationNameException {
        return this.filesetCatalogOperations.getFileLocation(ident, subPath, locationName);
    }

    public void close() throws IOException {
        this.filesetCatalogOperations.close();
        this.catalogUserContext.close();
        UserContext.cleanAllUserContext();
        ClassLoaderResourceCleanerUtils.closeClassLoaderResource((ClassLoader)this.getClass().getClassLoader());
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
        this.filesetCatalogOperations.testConnection(catalogIdent, type, provider, comment, properties);
    }

    public List<PathContext> getPathContext(NameIdentifier filesetIdentifier) {
        Fileset fileset = this.loadFileset(filesetIdentifier);
        String path = this.getTargetLocation(fileset);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> ((Fileset)fileset).properties();
        supplierArray[1] = () -> {
            Namespace namespace = filesetIdentifier.namespace();
            NameIdentifier schemaIdentifier = NameIdentifierUtil.ofSchema((String)namespace.level(0), (String)namespace.level(1), (String)namespace.level(2));
            return this.loadSchema(schemaIdentifier).properties();
        };
        supplierArray[2] = () -> this.catalogProperties;
        Set providers = CredentialUtils.getCredentialProvidersByOrder((Supplier[])supplierArray);
        return providers.stream().map(provider -> new PathContext(path, provider)).collect(Collectors.toList());
    }

    @VisibleForTesting
    protected String getTargetLocation(Fileset fileset) {
        String targetLocation;
        String targetLocationName;
        CallerContext callerContext = CallerContext.CallerContextHolder.get();
        if (callerContext != null && callerContext.context().containsKey("Current-Location-Name")) {
            targetLocationName = (String)callerContext.context().get("Current-Location-Name");
            Preconditions.checkArgument((boolean)fileset.storageLocations().containsKey(targetLocationName), (String)"The location name %s is not in the fileset %s, expected location names are %s", (Object)targetLocationName, (Object)fileset.name(), fileset.storageLocations().keySet());
            targetLocation = (String)fileset.storageLocations().get(targetLocationName);
        } else if (fileset.storageLocations().size() == 1) {
            targetLocation = (String)fileset.storageLocations().values().iterator().next();
            targetLocationName = (String)fileset.storageLocations().keySet().iterator().next();
        } else {
            targetLocationName = (String)fileset.properties().get("default-location-name");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)targetLocationName), (String)"The default location name of the fileset %s should not be empty.", (Object)fileset.name());
            targetLocation = (String)fileset.storageLocations().get(targetLocationName);
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)targetLocation), (String)"The location with the location name %s of the fileset %s should not be empty.", (Object)targetLocationName, (Object)fileset.name());
        return targetLocation;
    }

    private void setUser(String apiUser) {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        subject.getPrincipals().add((Principal)new UserPrincipal(apiUser));
    }

    private void unsetUser(String apiUser) {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        subject.getPrincipals().removeIf(principal -> principal.getName().equals(apiUser));
    }
}

