/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.JobTemplateEntity;
import org.apache.gravitino.storage.relational.mapper.JobMetaMapper;
import org.apache.gravitino.storage.relational.mapper.JobTemplateMetaMapper;
import org.apache.gravitino.storage.relational.po.JobTemplatePO;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.SessionUtils;

public class JobTemplateMetaService {
    private static final JobTemplateMetaService INSTANCE = new JobTemplateMetaService();

    private JobTemplateMetaService() {
    }

    public static JobTemplateMetaService getInstance() {
        return INSTANCE;
    }

    public List<JobTemplateEntity> listJobTemplatesByNamespace(Namespace ns) {
        String metalakeName = ns.level(0);
        List jobTemplatePOs = SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, mapper -> mapper.listJobTemplatePOsByMetalake(metalakeName));
        return jobTemplatePOs.stream().map(p -> JobTemplatePO.fromJobTemplatePO(p, ns)).collect(Collectors.toList());
    }

    public JobTemplateEntity getJobTemplateByIdentifier(NameIdentifier jobTemplateIdent) {
        String jobTemplateName;
        String metalakeName = jobTemplateIdent.namespace().level(0);
        JobTemplatePO jobTemplatePO = SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, arg_0 -> JobTemplateMetaService.lambda$getJobTemplateByIdentifier$2(metalakeName, jobTemplateName = jobTemplateIdent.name(), arg_0));
        if (jobTemplatePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.JOB_TEMPLATE.name().toLowerCase(Locale.ROOT), jobTemplateName});
        }
        return JobTemplatePO.fromJobTemplatePO(jobTemplatePO, jobTemplateIdent.namespace());
    }

    public void insertJobTemplate(JobTemplateEntity jobTemplateEntity, boolean overwrite) throws IOException {
        String metalakeName = jobTemplateEntity.namespace().level(0);
        try {
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalakeName);
            JobTemplatePO.JobTemplatePOBuilder builder = JobTemplatePO.builder().withMetalakeId(metalakeId);
            JobTemplatePO jobTemplatePO = JobTemplatePO.initializeJobTemplatePO(jobTemplateEntity, builder);
            SessionUtils.doWithCommit(JobTemplateMetaMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertJobTemplateMetaOnDuplicateKeyUpdate(jobTemplatePO);
                } else {
                    mapper.insertJobTemplateMeta(jobTemplatePO);
                }
            });
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.JOB_TEMPLATE, jobTemplateEntity.name());
            throw e;
        }
    }

    public boolean deleteJobTemplate(NameIdentifier jobTemplateIdent) {
        String metalakeName = jobTemplateIdent.namespace().level(0);
        String jobTemplateName = jobTemplateIdent.name();
        AtomicInteger result = new AtomicInteger(0);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(JobMetaMapper.class, mapper -> mapper.softDeleteJobMetaByMetalakeAndTemplate(metalakeName, jobTemplateName)), () -> result.set(SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, mapper -> mapper.softDeleteJobTemplateMetaByMetalakeAndName(metalakeName, jobTemplateName))));
        return result.get() > 0;
    }

    public int deleteJobTemplatesByLegacyTimeline(long legacyTimeline, int limit) {
        return SessionUtils.doWithCommitAndFetchResult(JobTemplateMetaMapper.class, mapper -> mapper.deleteJobTemplateMetasByLegacyTimeline(legacyTimeline, limit));
    }

    private static /* synthetic */ JobTemplatePO lambda$getJobTemplateByIdentifier$2(String metalakeName, String jobTemplateName, JobTemplateMetaMapper mapper) {
        return mapper.selectJobTemplatePOByMetalakeAndName(metalakeName, jobTemplateName);
    }
}

