/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.dto.rel.DistributionDTO;
import org.apache.gravitino.dto.rel.SortOrderDTO;
import org.apache.gravitino.dto.rel.expressions.FieldReferenceDTO;
import org.apache.gravitino.dto.rel.expressions.FuncExpressionDTO;
import org.apache.gravitino.dto.rel.expressions.FunctionArg;
import org.apache.gravitino.dto.rel.expressions.LiteralDTO;
import org.apache.gravitino.dto.rel.expressions.UnparsedExpressionDTO;
import org.apache.gravitino.dto.rel.indexes.IndexDTO;
import org.apache.gravitino.dto.rel.partitioning.BucketPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.DayPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.FunctionPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.HourPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.IdentityPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.ListPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.MonthPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.dto.rel.partitioning.RangePartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.TruncatePartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.YearPartitioningDTO;
import org.apache.gravitino.dto.rel.partitions.IdentityPartitionDTO;
import org.apache.gravitino.dto.rel.partitions.ListPartitionDTO;
import org.apache.gravitino.dto.rel.partitions.PartitionDTO;
import org.apache.gravitino.dto.rel.partitions.RangePartitionDTO;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.UnparsedExpression;
import org.apache.gravitino.rel.expressions.distributions.Strategy;
import org.apache.gravitino.rel.expressions.sorts.NullOrdering;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.stats.StatisticValue;
import org.apache.gravitino.stats.StatisticValues;

public class JsonUtils {
    private static final String NAMESPACE = "namespace";
    private static final String NAME = "name";
    private static final String POSITION_FIRST = "first";
    private static final String POSITION_AFTER = "after";
    private static final String POSITION_DEFAULT = "default";
    private static final String STRATEGY = "strategy";
    private static final String FIELD_NAME = "fieldName";
    private static final String FIELD_NAMES = "fieldNames";
    private static final String ASSIGNMENTS_NAME = "assignments";
    private static final String NUM_BUCKETS = "numBuckets";
    private static final String WIDTH = "width";
    private static final String FUNCTION_NAME = "funcName";
    private static final String FUNCTION_ARGS = "funcArgs";
    private static final String EXPRESSION_TYPE = "type";
    private static final String DATA_TYPE = "dataType";
    private static final String LITERAL_VALUE = "value";
    private static final String UNPARSED_EXPRESSION = "unparsedExpression";
    private static final String SORT_TERM = "sortTerm";
    private static final String DIRECTION = "direction";
    private static final String NULL_ORDERING = "nullOrdering";
    private static final String INDEX_TYPE = "indexType";
    private static final String INDEX_NAME = "name";
    private static final String INDEX_FIELD_NAMES = "fieldNames";
    private static final String NUMBER = "number";
    private static final String TYPE = "type";
    private static final String STRUCT = "struct";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String UNION = "union";
    private static final String UNPARSED = "unparsed";
    private static final String UNPARSED_TYPE = "unparsedType";
    private static final String EXTERNAL = "external";
    private static final String CATALOG_STRING = "catalogString";
    private static final String FIELDS = "fields";
    private static final String UNION_TYPES = "types";
    private static final String STRUCT_FIELD_NAME = "name";
    private static final String STRUCT_FIELD_NULLABLE = "nullable";
    private static final String STRUCT_FIELD_COMMENT = "comment";
    private static final String LIST_ELEMENT_NULLABLE = "containsNull";
    private static final String LIST_ELEMENT_TYPE = "elementType";
    private static final String MAP_KEY_TYPE = "keyType";
    private static final String MAP_VALUE_TYPE = "valueType";
    private static final String MAP_VALUE_NULLABLE = "valueContainsNull";
    private static final String PARTITION_TYPE = "type";
    private static final String PARTITION_NAME = "name";
    private static final String PARTITION_PROPERTIES = "properties";
    private static final String IDENTITY_PARTITION_VALUES = "values";
    private static final String LIST_PARTITION_LISTS = "lists";
    private static final String RANGE_PARTITION_UPPER = "upper";
    private static final String RANGE_PARTITION_LOWER = "lower";
    private static final ImmutableMap<String, Type.PrimitiveType> TYPES = Maps.uniqueIndex((Iterable)ImmutableList.of((Object)Types.BooleanType.get(), (Object)Types.ByteType.get(), (Object)Types.ByteType.unsigned(), (Object)Types.ShortType.get(), (Object)Types.ShortType.unsigned(), (Object)Types.IntegerType.get(), (Object)Types.IntegerType.unsigned(), (Object)Types.LongType.get(), (Object)Types.LongType.unsigned(), (Object)Types.FloatType.get(), (Object)Types.DoubleType.get(), (Object)Types.DateType.get(), (Object[])new Type.PrimitiveType[]{Types.TimeType.get(), Types.TimestampType.withTimeZone(), Types.TimestampType.withoutTimeZone(), Types.StringType.get(), Types.UUIDType.get(), Types.BinaryType.get(), Types.IntervalYearType.get(), Types.IntervalDayType.get()}), Type::simpleString);
    private static final Pattern FIXED = Pattern.compile("fixed\\(\\s*(\\d+)\\s*\\)");
    private static final Pattern FIXEDCHAR = Pattern.compile("char\\(\\s*(\\d+)\\s*\\)");
    private static final Pattern VARCHAR = Pattern.compile("varchar\\(\\s*(\\d+)\\s*\\)");
    private static final Pattern DECIMAL = Pattern.compile("decimal\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)");
    private static final Pattern TIME = Pattern.compile("time\\((\\d+)\\)");
    private static final Pattern TIMESTAMP_TZ = Pattern.compile("timestamp_tz\\((\\d+)\\)");
    private static final Pattern TIMESTAMP = Pattern.compile("timestamp\\((\\d+)\\)");

    @VisibleForTesting
    public static ObjectMapper objectMapper() {
        return ObjectMapperHolder.INSTANCE;
    }

    public static ObjectMapper anyFieldMapper() {
        return AnyFieldMapperHolder.INSTANCE;
    }

    static List<String> getStringListOrNull(String property, JsonNode node) {
        if (!node.has(property) || node.get(property).isNull()) {
            return null;
        }
        return JsonUtils.getStringList(property, node);
    }

    private static List<String> getStringList(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing property: %s", (Object)property);
        return ImmutableList.builder().addAll((Iterator)new JsonStringArrayIterator(property, node)).build();
    }

    private static String[] getStringArray(ArrayNode node) {
        String[] array = new String[node.size()];
        for (int i = 0; i < node.size(); ++i) {
            array[i] = node.get(i).asText();
        }
        return array;
    }

    public static int getInt(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing property: %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isInt() ? 1 : 0) != 0, (String)"Cannot parse to an int value %s: %s", (Object)property, (Object)pNode);
        return pNode.asInt();
    }

    public static long getLong(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing property: %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isIntegralNumber() && pNode.canConvertToLong() ? 1 : 0) != 0, (String)"Cannot parse to an long value %s: %s", (Object)property, (Object)pNode);
        return pNode.asLong();
    }

    private static FunctionArg readFunctionArg(JsonNode node) {
        Preconditions.checkArgument((node != null && !node.isNull() && node.isObject() ? 1 : 0) != 0, (String)"Cannot parse function arg from invalid JSON: %s", (Object)node);
        Preconditions.checkArgument((boolean)node.has("type"), (String)"Cannot parse function arg from missing type: %s", (Object)node);
        String type = JsonUtils.getString("type", node);
        switch (FunctionArg.ArgType.valueOf(type.toUpperCase())) {
            case LITERAL: {
                Preconditions.checkArgument((boolean)node.has(DATA_TYPE), (String)"Cannot parse literal arg from missing data type: %s", (Object)node);
                Preconditions.checkArgument((boolean)node.has(LITERAL_VALUE), (String)"Cannot parse literal arg from missing literal value: %s", (Object)node);
                Type dataType = JsonUtils.readDataType(node.get(DATA_TYPE));
                String value = JsonUtils.getStringOrNull(LITERAL_VALUE, node);
                return LiteralDTO.builder().withDataType(dataType).withValue(value).build();
            }
            case FIELD: {
                Preconditions.checkArgument((boolean)node.has(FIELD_NAME), (String)"Cannot parse field reference arg from missing field name: %s", (Object)node);
                String[] fieldName = JsonUtils.getStringList(FIELD_NAME, node).toArray(new String[0]);
                return FieldReferenceDTO.of(fieldName);
            }
            case FUNCTION: {
                Preconditions.checkArgument((boolean)node.has(FUNCTION_NAME), (String)"Cannot parse function function arg from missing function name: %s", (Object)node);
                Preconditions.checkArgument((boolean)node.has(FUNCTION_ARGS), (String)"Cannot parse function function arg from missing function args: %s", (Object)node);
                String functionName = JsonUtils.getString(FUNCTION_NAME, node);
                ArrayList args = Lists.newArrayList();
                node.get(FUNCTION_ARGS).forEach(arg -> args.add(JsonUtils.readFunctionArg(arg)));
                return FuncExpressionDTO.builder().withFunctionName(functionName).withFunctionArgs(args.toArray(FunctionArg.EMPTY_ARGS)).build();
            }
            case UNPARSED: {
                Preconditions.checkArgument((node.has(UNPARSED_EXPRESSION) && node.get(UNPARSED_EXPRESSION).isTextual() ? 1 : 0) != 0, (String)"Cannot parse unparsed expression from missing string field unparsedExpression: %s", (Object)node);
                return UnparsedExpressionDTO.builder().withUnparsedExpression(JsonUtils.getString(UNPARSED_EXPRESSION, node)).build();
            }
        }
        throw new IllegalArgumentException("Unknown function argument type: " + type);
    }

    private static void writeFunctionArg(FunctionArg arg, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", arg.argType().name().toLowerCase());
        switch (arg.argType()) {
            case LITERAL: {
                gen.writeFieldName(DATA_TYPE);
                JsonUtils.writeDataType(((LiteralDTO)arg).dataType(), gen);
                gen.writeStringField(LITERAL_VALUE, ((LiteralDTO)arg).value());
                break;
            }
            case FIELD: {
                gen.writeFieldName(FIELD_NAME);
                gen.writeObject((Object)((FieldReferenceDTO)arg).fieldName());
                break;
            }
            case FUNCTION: {
                gen.writeStringField(FUNCTION_NAME, ((FuncExpressionDTO)arg).functionName());
                gen.writeArrayFieldStart(FUNCTION_ARGS);
                for (FunctionArg funcArg : ((FuncExpressionDTO)arg).args()) {
                    JsonUtils.writeFunctionArg(funcArg, gen);
                }
                gen.writeEndArray();
                break;
            }
            case UNPARSED: {
                gen.writeStringField(UNPARSED_EXPRESSION, ((UnparsedExpression)arg).unparsedExpression());
                break;
            }
            default: {
                throw new IOException("Unknown function argument type: " + String.valueOf((Object)arg.argType()));
            }
        }
        gen.writeEndObject();
    }

    private static void writePartition(PartitionDTO value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", value.type().name().toLowerCase());
        gen.writeStringField("name", value.name());
        switch (value.type()) {
            case IDENTITY: {
                IdentityPartitionDTO identityPartitionDTO = (IdentityPartitionDTO)value;
                gen.writeFieldName("fieldNames");
                gen.writeObject((Object)identityPartitionDTO.fieldNames());
                gen.writeArrayFieldStart(IDENTITY_PARTITION_VALUES);
                for (LiteralDTO literal : identityPartitionDTO.values()) {
                    JsonUtils.writeFunctionArg(literal, gen);
                }
                gen.writeEndArray();
                break;
            }
            case LIST: {
                ListPartitionDTO listPartitionDTO = (ListPartitionDTO)value;
                gen.writeArrayFieldStart(LIST_PARTITION_LISTS);
                for (LiteralDTO[] literals : listPartitionDTO.lists()) {
                    gen.writeStartArray();
                    for (LiteralDTO literal : literals) {
                        JsonUtils.writeFunctionArg(literal, gen);
                    }
                    gen.writeEndArray();
                }
                gen.writeEndArray();
                break;
            }
            case RANGE: {
                RangePartitionDTO rangePartitionDTO = (RangePartitionDTO)value;
                gen.writeFieldName(RANGE_PARTITION_UPPER);
                JsonUtils.writeFunctionArg(rangePartitionDTO.upper(), gen);
                gen.writeFieldName(RANGE_PARTITION_LOWER);
                JsonUtils.writeFunctionArg(rangePartitionDTO.lower(), gen);
                break;
            }
            default: {
                throw new IOException("Unknown partition type: " + String.valueOf((Object)value.type()));
            }
        }
        gen.writeObjectField(PARTITION_PROPERTIES, (Object)value.properties());
        gen.writeEndObject();
    }

    private static PartitionDTO readPartition(JsonNode node) {
        Preconditions.checkArgument((node != null && !node.isNull() && node.isObject() ? 1 : 0) != 0, (String)"Partition must be a valid JSON object, but found: %s", (Object)node);
        Preconditions.checkArgument((boolean)node.has("type"), (String)"Partition must have a type field, but found: %s", (Object)node);
        String type = JsonUtils.getString("type", node);
        switch (PartitionDTO.Type.valueOf(type.toUpperCase())) {
            case IDENTITY: {
                Preconditions.checkArgument((node.has("fieldNames") && node.get("fieldNames").isArray() ? 1 : 0) != 0, (String)"Identity partition must have array of fieldNames, but found: %s", (Object)node);
                Preconditions.checkArgument((node.has(IDENTITY_PARTITION_VALUES) && node.get(IDENTITY_PARTITION_VALUES).isArray() ? 1 : 0) != 0, (String)"Identity partition must have array of values, but found: %s", (Object)node);
                ArrayList fieldNames = Lists.newArrayList();
                node.get("fieldNames").forEach(field -> fieldNames.add(JsonUtils.getStringArray((ArrayNode)field)));
                ArrayList values = Lists.newArrayList();
                node.get(IDENTITY_PARTITION_VALUES).forEach(value -> values.add((LiteralDTO)JsonUtils.readFunctionArg(value)));
                return IdentityPartitionDTO.builder().withName(JsonUtils.getStringOrNull("name", node)).withFieldNames((String[][])fieldNames.toArray((T[])new String[0][0])).withValues(values.toArray(new LiteralDTO[0])).withProperties(JsonUtils.getStringMapOrNull(PARTITION_PROPERTIES, node)).build();
            }
            case LIST: {
                Preconditions.checkArgument((boolean)node.has("name"), (String)"List partition must have name, but found: %s", (Object)node);
                Preconditions.checkArgument((node.has(LIST_PARTITION_LISTS) && node.get(LIST_PARTITION_LISTS).isArray() ? 1 : 0) != 0, (String)"List partition must have array of lists, but found: %s", (Object)node);
                ArrayList lists = Lists.newArrayList();
                node.get(LIST_PARTITION_LISTS).forEach(list -> {
                    ArrayList literals = Lists.newArrayList();
                    list.forEach(literal -> literals.add((LiteralDTO)JsonUtils.readFunctionArg(literal)));
                    lists.add(literals.toArray(new LiteralDTO[0]));
                });
                return ListPartitionDTO.builder().withName(JsonUtils.getStringOrNull("name", node)).withLists((LiteralDTO[][])lists.toArray((T[])new LiteralDTO[0][0])).withProperties(JsonUtils.getStringMapOrNull(PARTITION_PROPERTIES, node)).build();
            }
            case RANGE: {
                Preconditions.checkArgument((boolean)node.has("name"), (String)"Range partition must have name, but found: %s", (Object)node);
                Preconditions.checkArgument((boolean)node.has(RANGE_PARTITION_UPPER), (String)"Range partition must have upper, but found: %s", (Object)node);
                Preconditions.checkArgument((boolean)node.has(RANGE_PARTITION_LOWER), (String)"Range partition must have lower, but found: %s", (Object)node);
                LiteralDTO upper = (LiteralDTO)JsonUtils.readFunctionArg(node.get(RANGE_PARTITION_UPPER));
                LiteralDTO lower = (LiteralDTO)JsonUtils.readFunctionArg(node.get(RANGE_PARTITION_LOWER));
                return RangePartitionDTO.builder().withName(JsonUtils.getStringOrNull("name", node)).withUpper(upper).withLower(lower).withProperties(JsonUtils.getStringMapOrNull(PARTITION_PROPERTIES, node)).build();
            }
        }
        throw new IllegalArgumentException("Unknown partition type: " + type);
    }

    public static String getString(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing string: %s", (Object)property);
        JsonNode pNode = node.get(property);
        return JsonUtils.convertToString(property, pNode);
    }

    private static String getStringOrNull(String property, JsonNode node) {
        if (!node.has(property) || node.get(property).isNull()) {
            return null;
        }
        return JsonUtils.getString(property, node);
    }

    private static Map<String, String> getStringMapOrNull(String property, JsonNode node) {
        if (!node.has(property) || node.get(property).isNull()) {
            return null;
        }
        JsonNode propertiesNode = node.get(property);
        Iterator fieldsIterator = propertiesNode.fields();
        HashMap properties = Maps.newHashMap();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            properties.put((String)field.getKey(), ((JsonNode)field.getValue()).asText());
        }
        return properties;
    }

    private static String convertToString(String property, JsonNode pNode) {
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isTextual() ? 1 : 0) != 0, (String)"Cannot parse to a string value %s: %s", (Object)property, (Object)pNode);
        return pNode.asText();
    }

    private static void writeDataType(Type dataType, JsonGenerator gen) throws IOException {
        switch (dataType.name()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case STRING: 
            case FIXEDCHAR: 
            case VARCHAR: 
            case INTERVAL_DAY: 
            case INTERVAL_YEAR: 
            case UUID: 
            case FIXED: 
            case BINARY: 
            case NULL: {
                gen.writeString(dataType.simpleString());
                break;
            }
            case STRUCT: {
                JsonUtils.writeStructType((Types.StructType)dataType, gen);
                break;
            }
            case LIST: {
                JsonUtils.writeListType((Types.ListType)dataType, gen);
                break;
            }
            case MAP: {
                JsonUtils.writeMapType((Types.MapType)dataType, gen);
                break;
            }
            case UNION: {
                JsonUtils.writeUnionType((Types.UnionType)dataType, gen);
                break;
            }
            case UNPARSED: {
                JsonUtils.writeUnparsedType((Types.UnparsedType)dataType, gen);
                break;
            }
            case EXTERNAL: {
                JsonUtils.writeExternalType((Types.ExternalType)dataType, gen);
                break;
            }
            default: {
                JsonUtils.writeUnparsedType(dataType.simpleString(), gen);
            }
        }
    }

    private static Type readDataType(JsonNode node) {
        Preconditions.checkArgument((node != null && !node.isNull() ? 1 : 0) != 0, (String)"Cannot parse type from invalid JSON: %s", (Object)node);
        if (node.isTextual()) {
            String text = node.asText().toLowerCase();
            return text.equals(Types.NullType.get().simpleString()) ? Types.NullType.get() : JsonUtils.fromPrimitiveTypeString(text);
        }
        if (node.isObject() && node.has("type")) {
            String type = node.get("type").asText();
            if (STRUCT.equals(type)) {
                return JsonUtils.readStructType(node);
            }
            if (LIST.equals(type)) {
                return JsonUtils.readListType(node);
            }
            if (MAP.equals(type)) {
                return JsonUtils.readMapType(node);
            }
            if (UNION.equals(type)) {
                return JsonUtils.readUnionType(node);
            }
            if (UNPARSED.equals(type)) {
                return JsonUtils.readUnparsedType(node);
            }
            if (EXTERNAL.equals(type)) {
                return JsonUtils.readExternalType(node);
            }
        }
        return Types.UnparsedType.of((String)node.toString());
    }

    private static void writeUnionType(Types.UnionType unionType, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", UNION);
        gen.writeArrayFieldStart(UNION_TYPES);
        for (Type type : unionType.types()) {
            JsonUtils.writeDataType(type, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    private static void writeMapType(Types.MapType mapType, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", MAP);
        gen.writeBooleanField(MAP_VALUE_NULLABLE, mapType.valueNullable());
        gen.writeFieldName(MAP_KEY_TYPE);
        JsonUtils.writeDataType(mapType.keyType(), gen);
        gen.writeFieldName(MAP_VALUE_TYPE);
        JsonUtils.writeDataType(mapType.valueType(), gen);
        gen.writeEndObject();
    }

    private static void writeListType(Types.ListType listType, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", LIST);
        gen.writeBooleanField(LIST_ELEMENT_NULLABLE, listType.elementNullable());
        gen.writeFieldName(LIST_ELEMENT_TYPE);
        JsonUtils.writeDataType(listType.elementType(), gen);
        gen.writeEndObject();
    }

    private static void writeStructType(Types.StructType structType, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", STRUCT);
        gen.writeArrayFieldStart(FIELDS);
        for (Types.StructType.Field field : structType.fields()) {
            JsonUtils.writeStructField(field, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    private static void writeStructField(Types.StructType.Field field, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("name", field.name());
        gen.writeFieldName("type");
        JsonUtils.writeDataType(field.type(), gen);
        gen.writeBooleanField(STRUCT_FIELD_NULLABLE, field.nullable());
        if (field.comment() != null) {
            gen.writeStringField(STRUCT_FIELD_COMMENT, field.comment());
        }
        gen.writeEndObject();
    }

    private static void writeUnparsedType(Types.UnparsedType unparsedType, JsonGenerator gen) throws IOException {
        JsonUtils.writeUnparsedType(unparsedType.unparsedType(), gen);
    }

    private static void writeUnparsedType(String unparsedType, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", UNPARSED);
        gen.writeStringField(UNPARSED_TYPE, unparsedType);
        gen.writeEndObject();
    }

    private static void writeExternalType(Types.ExternalType externalType, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", EXTERNAL);
        gen.writeStringField(CATALOG_STRING, externalType.catalogString());
        gen.writeEndObject();
    }

    private static Type fromPrimitiveTypeString(String typeString) {
        Type.PrimitiveType primitiveType = (Type.PrimitiveType)TYPES.get((Object)typeString);
        if (primitiveType != null) {
            return primitiveType;
        }
        Matcher fixed = FIXED.matcher(typeString);
        if (fixed.matches()) {
            return Types.FixedType.of((int)Integer.parseInt(fixed.group(1)));
        }
        Matcher fixedChar = FIXEDCHAR.matcher(typeString);
        if (fixedChar.matches()) {
            return Types.FixedCharType.of((int)Integer.parseInt(fixedChar.group(1)));
        }
        Matcher varchar = VARCHAR.matcher(typeString);
        if (varchar.matches()) {
            return Types.VarCharType.of((int)Integer.parseInt(varchar.group(1)));
        }
        Matcher decimal = DECIMAL.matcher(typeString);
        if (decimal.matches()) {
            return Types.DecimalType.of((int)Integer.parseInt(decimal.group(1)), (int)Integer.parseInt(decimal.group(2)));
        }
        Matcher time = TIME.matcher(typeString);
        if (time.matches()) {
            return Types.TimeType.of((int)Integer.parseInt(time.group(1)));
        }
        Matcher timestampTz = TIMESTAMP_TZ.matcher(typeString);
        if (timestampTz.matches()) {
            return Types.TimestampType.withTimeZone((int)Integer.parseInt(timestampTz.group(1)));
        }
        Matcher timestamp = TIMESTAMP.matcher(typeString);
        if (timestamp.matches()) {
            return Types.TimestampType.withoutTimeZone((int)Integer.parseInt(timestamp.group(1)));
        }
        return Types.UnparsedType.of((String)typeString);
    }

    private static Types.StructType readStructType(JsonNode node) {
        JsonNode fields = node.get(FIELDS);
        Preconditions.checkArgument((fields != null && fields.isArray() ? 1 : 0) != 0, (String)"Cannot parse struct fields from non-array: %s", (Object)fields);
        ArrayList structFields = Lists.newArrayListWithExpectedSize((int)fields.size());
        for (JsonNode field : fields) {
            structFields.add(JsonUtils.readStructField(field));
        }
        return Types.StructType.of((Types.StructType.Field[])structFields.toArray(new Types.StructType.Field[0]));
    }

    private static Types.ListType readListType(JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(LIST_ELEMENT_TYPE), (String)"Cannot parse list type from missing element type: %s", (Object)node);
        Type elementType = JsonUtils.readDataType(node.get(LIST_ELEMENT_TYPE));
        boolean nullable = node.has(LIST_ELEMENT_NULLABLE) ? node.get(LIST_ELEMENT_NULLABLE).asBoolean() : true;
        return Types.ListType.of((Type)elementType, (boolean)nullable);
    }

    private static Types.MapType readMapType(JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(MAP_KEY_TYPE), (String)"Cannot parse map type from missing key type: %s", (Object)node);
        Preconditions.checkArgument((boolean)node.has(MAP_VALUE_TYPE), (String)"Cannot parse map type from missing value type: %s", (Object)node);
        Type keyType = JsonUtils.readDataType(node.get(MAP_KEY_TYPE));
        Type valueType = JsonUtils.readDataType(node.get(MAP_VALUE_TYPE));
        boolean nullable = node.has(MAP_VALUE_NULLABLE) ? node.get(MAP_VALUE_NULLABLE).asBoolean() : true;
        return Types.MapType.of((Type)keyType, (Type)valueType, (boolean)nullable);
    }

    private static Types.UnionType readUnionType(JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(UNION_TYPES), (String)"Cannot parse union type from missing types: %s", (Object)node);
        JsonNode types = node.get(UNION_TYPES);
        Preconditions.checkArgument((types != null && types.isArray() ? 1 : 0) != 0, (String)"Cannot parse union types from non-array: %s", (Object)types);
        ArrayList unionTypes = Lists.newArrayListWithExpectedSize((int)types.size());
        for (JsonNode type : types) {
            unionTypes.add(JsonUtils.readDataType(type));
        }
        return Types.UnionType.of((Type[])unionTypes.toArray(new Type[0]));
    }

    private static Types.StructType.Field readStructField(JsonNode node) {
        Preconditions.checkArgument((node != null && !node.isNull() && node.isObject() ? 1 : 0) != 0, (String)"Cannot parse struct field from invalid JSON: %s", (Object)node);
        Preconditions.checkArgument((boolean)node.has("name"), (String)"Cannot parse struct field from missing name: %s", (Object)node);
        Preconditions.checkArgument((boolean)node.has("type"), (String)"Cannot parse struct field from missing type: %s", (Object)node);
        String name = JsonUtils.getString("name", node);
        Type type = JsonUtils.readDataType(node.get("type"));
        boolean nullable = node.has(STRUCT_FIELD_NULLABLE) ? node.get(STRUCT_FIELD_NULLABLE).asBoolean() : true;
        String comment = node.has(STRUCT_FIELD_COMMENT) ? JsonUtils.getString(STRUCT_FIELD_COMMENT, node) : null;
        return Types.StructType.Field.of((String)name, (Type)type, (boolean)nullable, (String)comment);
    }

    private static Types.UnparsedType readUnparsedType(JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(UNPARSED_TYPE), (String)"Cannot parse unparsed type from missing unparsed type: %s", (Object)node);
        return Types.UnparsedType.of((String)node.get(UNPARSED_TYPE).asText());
    }

    private static Types.ExternalType readExternalType(JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(CATALOG_STRING), (String)"Cannot parse external type from missing catalogString: %s", (Object)node);
        return Types.ExternalType.of((String)node.get(CATALOG_STRING).asText());
    }

    private static StatisticValue<?> getStatisticValue(JsonNode node) throws IOException {
        Preconditions.checkArgument((node != null && !node.isNull() ? 1 : 0) != 0, (String)"Cannot parse statistic value from invalid JSON: %s", (Object)node);
        if (node.isIntegralNumber()) {
            return StatisticValues.longValue((long)node.asLong());
        }
        if (node.isFloatingPointNumber()) {
            return StatisticValues.doubleValue((double)node.asDouble());
        }
        if (node.isTextual()) {
            return StatisticValues.stringValue((String)node.asText());
        }
        if (node.isBoolean()) {
            return StatisticValues.booleanValue((boolean)node.asBoolean());
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            ArrayList values = Lists.newArrayListWithCapacity((int)arrayNode.size());
            for (JsonNode arrayElement : arrayNode) {
                StatisticValue<?> value = JsonUtils.getStatisticValue(arrayElement);
                if (value == null) continue;
                values.add(value);
            }
            return StatisticValues.listValue((List)values);
        }
        if (node.isObject()) {
            ObjectNode objectNode = (ObjectNode)node;
            HashMap map = Maps.newHashMap();
            objectNode.fields().forEachRemaining(entry -> {
                try {
                    StatisticValue<?> value = JsonUtils.getStatisticValue((JsonNode)entry.getValue());
                    if (value != null) {
                        map.put((String)entry.getKey(), value);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            return StatisticValues.objectValue((Map)map);
        }
        throw new UnsupportedEncodingException(String.format("Don't support json node type %s", node.getNodeType()));
    }

    private JsonUtils() {
    }

    private static class ObjectMapperHolder {
        private static final ObjectMapper INSTANCE = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)).configure((DatatypeFeature)EnumFeature.WRITE_ENUMS_TO_LOWERCASE, true)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module());

        private ObjectMapperHolder() {
        }
    }

    private static class AnyFieldMapperHolder {
        private static final ObjectMapper INSTANCE = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)).configure((DatatypeFeature)EnumFeature.WRITE_ENUMS_TO_LOWERCASE, true)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build()).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TypeDeserializer()).addSerializer(Type.class, (JsonSerializer)new TypeSerializer()).addDeserializer(Expression.class, (JsonDeserializer)new ColumnDefaultValueDeserializer()).addSerializer(Expression.class, (JsonSerializer)new ColumnDefaultValueSerializer()).addDeserializer(StatisticValue.class, (JsonDeserializer)new StatisticValueDeserializer()).addSerializer(StatisticValue.class, (JsonSerializer)new StatisticValueSerializer()));

        private AnyFieldMapperHolder() {
        }
    }

    static class JsonStringArrayIterator
    extends JsonArrayIterator<String> {
        private final String property;

        JsonStringArrayIterator(String property, JsonNode node) {
            super(property, node);
            this.property = property;
        }

        @Override
        String convert(JsonNode element) {
            return JsonUtils.convertToString(this.property, element);
        }
    }

    public static class IndexDeserializer
    extends JsonDeserializer<Index> {
        public Index deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            Preconditions.checkArgument((node != null && !node.isNull() && node.isObject() ? 1 : 0) != 0, (String)"Index must be a valid JSON object, but found: %s", (Object)node);
            IndexDTO.Builder builder = IndexDTO.builder();
            Preconditions.checkArgument((boolean)node.has(JsonUtils.INDEX_TYPE), (String)"Cannot parse index from missing type: %s", (Object)node);
            String indexType = JsonUtils.getString(JsonUtils.INDEX_TYPE, node);
            builder.withIndexType(Index.IndexType.valueOf((String)indexType.toUpperCase(Locale.ROOT)));
            if (node.has("name")) {
                builder.withName(JsonUtils.getString("name", node));
            }
            Preconditions.checkArgument((boolean)node.has("fieldNames"), (String)"Cannot parse index from missing field names: %s", (Object)node);
            ArrayList fieldNames = Lists.newArrayList();
            node.get("fieldNames").forEach(field -> fieldNames.add(JsonUtils.getStringArray((ArrayNode)field)));
            builder.withFieldNames((String[][])fieldNames.toArray((T[])new String[0][0]));
            return builder.build();
        }
    }

    public static class IndexSerializer
    extends JsonSerializer<Index> {
        public void serialize(Index value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField(JsonUtils.INDEX_TYPE, value.type().name().toUpperCase(Locale.ROOT));
            if (null != value.name()) {
                gen.writeStringField("name", value.name());
            }
            gen.writeFieldName("fieldNames");
            gen.writeObject((Object)value.fieldNames());
            gen.writeEndObject();
        }
    }

    public static class PartitionDTODeserializer
    extends JsonDeserializer<PartitionDTO> {
        public PartitionDTO deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return JsonUtils.readPartition(node);
        }
    }

    public static class PartitionDTOSerializer
    extends JsonSerializer<PartitionDTO> {
        public void serialize(PartitionDTO value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            JsonUtils.writePartition(value, gen);
        }
    }

    public static class StatisticValueSerializer
    extends JsonSerializer<StatisticValue> {
        public void serialize(StatisticValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value.dataType().name() == Type.Name.BOOLEAN) {
                gen.writeBoolean(((Boolean)value.value()).booleanValue());
            } else if (value.dataType().name() == Type.Name.STRING) {
                gen.writeString((String)value.value());
            } else if (value.dataType().name() == Type.Name.DOUBLE) {
                gen.writeNumber(((Double)value.value()).doubleValue());
            } else if (value.dataType().name() == Type.Name.LONG) {
                gen.writeNumber(((Long)value.value()).longValue());
            } else if (value.dataType().name() == Type.Name.LIST) {
                gen.writeStartArray();
                for (StatisticValue element : (List)value.value()) {
                    this.serialize(element, gen, serializers);
                }
                gen.writeEndArray();
            } else if (value.dataType().name() == Type.Name.STRUCT) {
                gen.writeStartObject();
                for (Map.Entry entry : ((Map)value.value()).entrySet()) {
                    gen.writeFieldName((String)entry.getKey());
                    this.serialize((StatisticValue)entry.getValue(), gen, serializers);
                }
                gen.writeEndObject();
            } else {
                throw new IOException("Unsupported statistic value type: " + String.valueOf(value.dataType()));
            }
        }
    }

    public static class StatisticValueDeserializer
    extends JsonDeserializer<StatisticValue> {
        public StatisticValue<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return JsonUtils.getStatisticValue(node);
        }
    }

    public static class ColumnDefaultValueDeserializer
    extends JsonDeserializer<Expression> {
        public Expression deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node == null || node.isNull()) {
                return Column.DEFAULT_VALUE_NOT_SET;
            }
            return JsonUtils.readFunctionArg(node);
        }
    }

    public static class ColumnDefaultValueSerializer
    extends JsonSerializer<Expression> {
        public void serialize(Expression value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null || value.equals(Column.DEFAULT_VALUE_NOT_SET)) {
                return;
            }
            JsonUtils.writeFunctionArg((FunctionArg)value, gen);
        }

        public boolean isEmpty(SerializerProvider provider, Expression value) {
            return value == null || value.equals(Column.DEFAULT_VALUE_NOT_SET);
        }
    }

    public static class DistributionDeserializer
    extends JsonDeserializer<DistributionDTO> {
        public DistributionDTO deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            Preconditions.checkArgument((node != null && !node.isNull() && node.isObject() ? 1 : 0) != 0, (String)"Cannot parse distribution from invalid JSON: %s", (Object)node);
            DistributionDTO.Builder builder = DistributionDTO.builder();
            if (node.has(JsonUtils.STRATEGY)) {
                String strategy = JsonUtils.getString(JsonUtils.STRATEGY, node);
                builder.withStrategy(Strategy.getByName((String)strategy));
            }
            builder.withNumber(JsonUtils.getInt(JsonUtils.NUMBER, node));
            ArrayList args = Lists.newArrayList();
            node.get(JsonUtils.FUNCTION_ARGS).forEach(arg -> args.add(JsonUtils.readFunctionArg(arg)));
            return builder.withArgs(args.toArray(FunctionArg.EMPTY_ARGS)).build();
        }
    }

    public static class DistributionSerializer
    extends JsonSerializer<DistributionDTO> {
        public void serialize(DistributionDTO value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField(JsonUtils.STRATEGY, value.strategy().name().toLowerCase());
            gen.writeNumberField(JsonUtils.NUMBER, value.number());
            gen.writeArrayFieldStart(JsonUtils.FUNCTION_ARGS);
            for (FunctionArg arg : value.args()) {
                JsonUtils.writeFunctionArg(arg, gen);
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }

    public static class SortOrderDeserializer
    extends JsonDeserializer<SortOrderDTO> {
        public SortOrderDTO deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            Preconditions.checkArgument((node != null && !node.isNull() && node.isObject() ? 1 : 0) != 0, (String)"Cannot parse sort order from invalid JSON: %s", (Object)node);
            Preconditions.checkArgument((boolean)node.has(JsonUtils.SORT_TERM), (String)"Cannot parse sort order from missing sort term: %s", (Object)node);
            FunctionArg sortTerm = JsonUtils.readFunctionArg(node.get(JsonUtils.SORT_TERM));
            SortOrderDTO.Builder builder = SortOrderDTO.builder().withSortTerm(sortTerm);
            if (node.has(JsonUtils.DIRECTION)) {
                builder.withDirection(SortDirection.fromString((String)JsonUtils.getString(JsonUtils.DIRECTION, node)));
            }
            if (node.has(JsonUtils.NULL_ORDERING)) {
                builder.withNullOrder(NullOrdering.valueOf((String)JsonUtils.getString(JsonUtils.NULL_ORDERING, node).toUpperCase()));
            }
            return builder.build();
        }
    }

    public static class SortOrderSerializer
    extends JsonSerializer<SortOrderDTO> {
        public void serialize(SortOrderDTO value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName(JsonUtils.SORT_TERM);
            JsonUtils.writeFunctionArg(value.sortTerm(), gen);
            gen.writeStringField(JsonUtils.DIRECTION, value.direction().toString());
            gen.writeStringField(JsonUtils.NULL_ORDERING, value.nullOrdering().toString());
            gen.writeEndObject();
        }
    }

    public static class PartitioningDeserializer
    extends JsonDeserializer<Partitioning> {
        public Partitioning deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            Preconditions.checkArgument((node != null && !node.isNull() && node.isObject() ? 1 : 0) != 0, (String)"Cannot parse partitioning from invalid JSON: %s", (Object)node);
            Preconditions.checkArgument((boolean)node.has(JsonUtils.STRATEGY), (String)"Cannot parse partitioning from missing strategy: %s", (Object)node);
            String strategy = JsonUtils.getString(JsonUtils.STRATEGY, node);
            switch (Partitioning.Strategy.getByName(strategy)) {
                case IDENTITY: {
                    return IdentityPartitioningDTO.of(JsonUtils.getStringList(JsonUtils.FIELD_NAME, node).toArray(new String[0]));
                }
                case YEAR: {
                    return YearPartitioningDTO.of(JsonUtils.getStringList(JsonUtils.FIELD_NAME, node).toArray(new String[0]));
                }
                case MONTH: {
                    return MonthPartitioningDTO.of(JsonUtils.getStringList(JsonUtils.FIELD_NAME, node).toArray(new String[0]));
                }
                case DAY: {
                    return DayPartitioningDTO.of(JsonUtils.getStringList(JsonUtils.FIELD_NAME, node).toArray(new String[0]));
                }
                case HOUR: {
                    return HourPartitioningDTO.of(JsonUtils.getStringList(JsonUtils.FIELD_NAME, node).toArray(new String[0]));
                }
                case BUCKET: {
                    int numBuckets = JsonUtils.getInt(JsonUtils.NUM_BUCKETS, node);
                    ArrayList fieldNames = Lists.newArrayList();
                    node.get("fieldNames").forEach(field -> fieldNames.add(JsonUtils.getStringArray((ArrayNode)field)));
                    return BucketPartitioningDTO.of(numBuckets, (String[][])fieldNames.toArray((T[])new String[0][0]));
                }
                case TRUNCATE: {
                    int width = JsonUtils.getInt(JsonUtils.WIDTH, node);
                    return TruncatePartitioningDTO.of(width, JsonUtils.getStringList(JsonUtils.FIELD_NAME, node).toArray(new String[0]));
                }
                case LIST: {
                    ArrayList listFields = Lists.newArrayList();
                    node.get("fieldNames").forEach(field -> listFields.add(JsonUtils.getStringArray((ArrayNode)field)));
                    if (!node.hasNonNull(JsonUtils.ASSIGNMENTS_NAME)) {
                        return ListPartitioningDTO.of((String[][])listFields.toArray((T[])new String[0][0]));
                    }
                    Preconditions.checkArgument((boolean)node.get(JsonUtils.ASSIGNMENTS_NAME).isArray(), (String)"Cannot parse list partitioning from non-array assignments: %s", (Object)node);
                    ArrayList assignments = Lists.newArrayList();
                    node.get(JsonUtils.ASSIGNMENTS_NAME).forEach(assignment -> {
                        PartitionDTO partitionDTO = JsonUtils.readPartition(assignment);
                        Preconditions.checkArgument((boolean)(partitionDTO instanceof ListPartitionDTO), (String)"Cannot parse list partitioning from non-list assignment: %s", (Object)assignment);
                        assignments.add((ListPartitionDTO)partitionDTO);
                    });
                    return ListPartitioningDTO.of((String[][])listFields.toArray((T[])new String[0][0]), assignments.toArray(new ListPartitionDTO[0]));
                }
                case RANGE: {
                    String[] fields = JsonUtils.getStringList(JsonUtils.FIELD_NAME, node).toArray(new String[0]);
                    if (!node.hasNonNull(JsonUtils.ASSIGNMENTS_NAME)) {
                        return RangePartitioningDTO.of(fields);
                    }
                    Preconditions.checkArgument((boolean)node.get(JsonUtils.ASSIGNMENTS_NAME).isArray(), (String)"Cannot parse range partitioning from non-array assignments: %s", (Object)node);
                    ArrayList rangeAssignments = Lists.newArrayList();
                    node.get(JsonUtils.ASSIGNMENTS_NAME).forEach(assignment -> {
                        PartitionDTO partitionDTO = JsonUtils.readPartition(assignment);
                        Preconditions.checkArgument((boolean)(partitionDTO instanceof RangePartitionDTO), (String)"Cannot parse range partitioning from non-range assignment: %s", (Object)assignment);
                        rangeAssignments.add((RangePartitionDTO)partitionDTO);
                    });
                    return RangePartitioningDTO.of(fields, rangeAssignments.toArray(new RangePartitionDTO[0]));
                }
                case FUNCTION: {
                    String functionName = JsonUtils.getString(JsonUtils.FUNCTION_NAME, node);
                    Preconditions.checkArgument((boolean)node.has(JsonUtils.FUNCTION_ARGS), (String)"Cannot parse function partitioning from missing function args: %s", (Object)node);
                    ArrayList args = Lists.newArrayList();
                    node.get(JsonUtils.FUNCTION_ARGS).forEach(arg -> args.add(JsonUtils.readFunctionArg(arg)));
                    return FunctionPartitioningDTO.of(functionName, args.toArray(FunctionArg.EMPTY_ARGS));
                }
            }
            throw new IOException("Unknown partitioning strategy: " + strategy);
        }
    }

    public static class PartitioningSerializer
    extends JsonSerializer<Partitioning> {
        public void serialize(Partitioning value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField(JsonUtils.STRATEGY, value.strategy().name().toLowerCase());
            switch (value.strategy()) {
                case IDENTITY: 
                case YEAR: 
                case MONTH: 
                case DAY: 
                case HOUR: {
                    String[] fieldName = ((Partitioning.SingleFieldPartitioning)value).fieldName();
                    gen.writeFieldName(JsonUtils.FIELD_NAME);
                    gen.writeObject((Object)fieldName);
                    break;
                }
                case BUCKET: {
                    BucketPartitioningDTO bucketPartitioningDTO = (BucketPartitioningDTO)value;
                    gen.writeNumberField(JsonUtils.NUM_BUCKETS, bucketPartitioningDTO.numBuckets());
                    gen.writeFieldName("fieldNames");
                    gen.writeObject((Object)bucketPartitioningDTO.fieldNames());
                    break;
                }
                case TRUNCATE: {
                    TruncatePartitioningDTO truncatePartitioningDTO = (TruncatePartitioningDTO)value;
                    gen.writeNumberField(JsonUtils.WIDTH, truncatePartitioningDTO.width());
                    gen.writeFieldName(JsonUtils.FIELD_NAME);
                    gen.writeObject((Object)truncatePartitioningDTO.fieldName());
                    break;
                }
                case LIST: {
                    ListPartitioningDTO listPartitioningDTO = (ListPartitioningDTO)value;
                    gen.writeFieldName("fieldNames");
                    gen.writeObject((Object)listPartitioningDTO.fieldNames());
                    gen.writeArrayFieldStart(JsonUtils.ASSIGNMENTS_NAME);
                    for (ListPartitionDTO listPartitionDTO : listPartitioningDTO.assignments()) {
                        JsonUtils.writePartition(listPartitionDTO, gen);
                    }
                    gen.writeEndArray();
                    break;
                }
                case RANGE: {
                    RangePartitioningDTO rangePartitioningDTO = (RangePartitioningDTO)value;
                    gen.writeFieldName(JsonUtils.FIELD_NAME);
                    gen.writeObject((Object)rangePartitioningDTO.fieldName());
                    gen.writeArrayFieldStart(JsonUtils.ASSIGNMENTS_NAME);
                    for (RangePartitionDTO rangePartitionDTO : rangePartitioningDTO.assignments()) {
                        JsonUtils.writePartition(rangePartitionDTO, gen);
                    }
                    gen.writeEndArray();
                    break;
                }
                case FUNCTION: {
                    FunctionPartitioningDTO funcExpression = (FunctionPartitioningDTO)value;
                    gen.writeStringField(JsonUtils.FUNCTION_NAME, funcExpression.functionName());
                    gen.writeArrayFieldStart(JsonUtils.FUNCTION_ARGS);
                    for (FunctionArg arg : funcExpression.args()) {
                        JsonUtils.writeFunctionArg(arg, gen);
                    }
                    gen.writeEndArray();
                    break;
                }
                default: {
                    throw new IOException("Unknown partitioning strategy: " + String.valueOf((Object)value.strategy()));
                }
            }
            gen.writeEndObject();
        }
    }

    public static class ColumnPositionDeserializer
    extends JsonDeserializer<TableChange.ColumnPosition> {
        public TableChange.ColumnPosition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            Preconditions.checkArgument((node != null && !node.isNull() ? 1 : 0) != 0, (String)"Cannot parse column position from invalid JSON: %s", (Object)node);
            if (node.isTextual() && (node.asText().equals(JsonUtils.POSITION_FIRST) || node.asText().equals(JsonUtils.POSITION_FIRST.toUpperCase()))) {
                return TableChange.ColumnPosition.first();
            }
            if (node.isTextual() && (node.asText().equalsIgnoreCase(JsonUtils.POSITION_DEFAULT) || node.asText().equalsIgnoreCase(JsonUtils.POSITION_DEFAULT.toUpperCase()))) {
                return TableChange.ColumnPosition.defaultPos();
            }
            if (node.isObject()) {
                String afterColumn = JsonUtils.getString(JsonUtils.POSITION_AFTER, node);
                return TableChange.ColumnPosition.after((String)afterColumn);
            }
            throw new IOException("Unknown json column position: " + String.valueOf(node));
        }
    }

    public static class ColumnPositionSerializer
    extends JsonSerializer<TableChange.ColumnPosition> {
        public void serialize(TableChange.ColumnPosition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value instanceof TableChange.First) {
                gen.writeString(JsonUtils.POSITION_FIRST);
            } else if (value instanceof TableChange.After) {
                gen.writeStartObject();
                TableChange.After after = (TableChange.After)value;
                gen.writeStringField(JsonUtils.POSITION_AFTER, after.getColumn());
                gen.writeEndObject();
            } else if (value instanceof TableChange.Default) {
                gen.writeString(JsonUtils.POSITION_DEFAULT);
            } else {
                throw new IOException("Unknown column position: " + String.valueOf(value));
            }
        }
    }

    public static class NameIdentifierDeserializer
    extends JsonDeserializer<NameIdentifier> {
        public NameIdentifier deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            Preconditions.checkArgument((node != null && !node.isNull() && node.isObject() ? 1 : 0) != 0, (String)"Cannot parse name identifier from invalid JSON: %s", (Object)node);
            List<String> levels = JsonUtils.getStringListOrNull(JsonUtils.NAMESPACE, node);
            String name = JsonUtils.getString("name", node);
            Namespace namespace = levels == null ? Namespace.empty() : Namespace.of((String[])levels.toArray(new String[0]));
            return NameIdentifier.of((Namespace)namespace, (String)name);
        }
    }

    public static class NameIdentifierSerializer
    extends JsonSerializer<NameIdentifier> {
        public void serialize(NameIdentifier value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName(JsonUtils.NAMESPACE);
            gen.writeArray(value.namespace().levels(), 0, value.namespace().length());
            gen.writeStringField("name", value.name());
            gen.writeEndObject();
        }
    }

    public static class TypeDeserializer
    extends JsonDeserializer<Type> {
        public Type deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return JsonUtils.readDataType((JsonNode)p.getCodec().readTree(p));
        }
    }

    public static class TypeSerializer
    extends JsonSerializer<Type> {
        public void serialize(Type value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            JsonUtils.writeDataType(value, gen);
        }
    }

    static abstract class JsonArrayIterator<T>
    implements Iterator<T> {
        private final Iterator<JsonNode> elements;

        JsonArrayIterator(String property, JsonNode node) {
            JsonNode pNode = node.get(property);
            Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isArray() ? 1 : 0) != 0, (String)"Cannot parse from non-array value: %s: %s", (Object)property, (Object)pNode);
            this.elements = pNode.elements();
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext();
        }

        @Override
        public T next() {
            JsonNode element = this.elements.next();
            return this.convert(element);
        }

        abstract T convert(JsonNode var1);
    }
}

