/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.tools;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import org.apache.flink.agents.api.annotation.ToolParam;
import org.apache.flink.agents.api.tools.Tool;
import org.apache.flink.agents.api.tools.ToolMetadata;
import org.apache.flink.agents.api.tools.ToolParameters;
import org.apache.flink.agents.api.tools.ToolResponse;
import org.apache.flink.agents.api.tools.ToolType;
import org.apache.flink.agents.plan.Function;
import org.apache.flink.agents.plan.JavaFunction;
import org.apache.flink.agents.plan.tools.SchemaUtils;
import org.apache.flink.agents.plan.tools.serializer.FunctionToolJsonDeserializer;
import org.apache.flink.agents.plan.tools.serializer.FunctionToolJsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=FunctionToolJsonSerializer.class)
@JsonDeserialize(using=FunctionToolJsonDeserializer.class)
public class FunctionTool
extends Tool {
    private final Function function;

    public FunctionTool(ToolMetadata metadata, Function function) {
        super(metadata);
        this.function = function;
    }

    public static FunctionTool fromStaticMethod(Method method) throws Exception {
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("FunctionTool only supports static methods. Method: " + method.getName());
        }
        org.apache.flink.agents.api.annotation.Tool toolAnnotation = method.getAnnotation(org.apache.flink.agents.api.annotation.Tool.class);
        String name = method.getName();
        String description = toolAnnotation != null ? toolAnnotation.description() : "";
        ToolMetadata metadata = new ToolMetadata(name, description, SchemaUtils.generateSchema(method));
        JavaFunction javaFunction = new JavaFunction(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        return new FunctionTool(metadata, javaFunction);
    }

    public static FunctionTool fromStaticMethod(String description, Method method) throws Exception {
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("FunctionTool only supports static methods. Method: " + method.getName());
        }
        ToolMetadata metadata = new ToolMetadata(method.getName(), description != null ? description : "", SchemaUtils.generateSchema(method));
        JavaFunction javaFunction = new JavaFunction(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        return new FunctionTool(metadata, javaFunction);
    }

    @Override
    public ToolType getToolType() {
        return ToolType.FUNCTION;
    }

    @Override
    public ToolResponse call(ToolParameters parameters) {
        try {
            Method method = ((JavaFunction)this.function).getMethod();
            Parameter[] methodParams = method.getParameters();
            Object[] args = new Object[methodParams.length];
            for (int i = 0; i < methodParams.length; ++i) {
                ToolParam ann;
                Object value;
                ToolParam ann2;
                Parameter p = methodParams[i];
                String paramName = p.getName();
                if (p.isAnnotationPresent(ToolParam.class) && !(ann2 = p.getAnnotation(ToolParam.class)).name().isEmpty()) {
                    paramName = ann2.name();
                }
                if ((value = parameters.getParameter(paramName, p.getType())) == null && p.isAnnotationPresent(ToolParam.class) && (ann = p.getAnnotation(ToolParam.class)).required() && ann.defaultValue().isEmpty()) {
                    throw new IllegalArgumentException("Missing required parameter: " + paramName);
                }
                args[i] = value;
            }
            Object result = this.function.call(args);
            return ToolResponse.success(result);
        }
        catch (Exception e) {
            return ToolResponse.error(e);
        }
    }

    public Function getFunction() {
        return this.function;
    }
}

