/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

public final class CsvRowSchemaConverter {
    private static final HashSet<TypeInformation<?>> NUMBER_TYPES = new HashSet<TypeInformation>(Arrays.asList(Types.BYTE, Types.SHORT, Types.INT, Types.LONG, Types.DOUBLE, Types.FLOAT, Types.BIG_DEC, Types.BIG_INT));
    private static final HashSet<LogicalTypeRoot> NUMBER_TYPE_ROOTS = new HashSet<LogicalTypeRoot>(Arrays.asList(LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DECIMAL));
    private static final HashSet<TypeInformation<?>> STRING_TYPES = new HashSet<TypeInformation>(Arrays.asList(Types.STRING, Types.SQL_DATE, Types.SQL_TIME, Types.SQL_TIMESTAMP, Types.LOCAL_DATE, Types.LOCAL_TIME, Types.LOCAL_DATE_TIME, Types.INSTANT));
    private static final HashSet<LogicalTypeRoot> STRING_TYPE_ROOTS = new HashSet<LogicalTypeRoot>(Arrays.asList(LogicalTypeRoot.CHAR, LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BINARY, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE));
    private static final HashSet<TypeInformation<?>> BOOLEAN_TYPES = new HashSet<TypeInformation>(Arrays.asList(Types.BOOLEAN, Types.VOID));
    private static final HashSet<LogicalTypeRoot> BOOLEAN_TYPE_ROOTS = new HashSet<LogicalTypeRoot>(Arrays.asList(LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.NULL));

    private CsvRowSchemaConverter() {
    }

    public static CsvSchema convert(RowTypeInfo rowType) {
        CsvSchema.Builder builder = new CsvSchema.Builder();
        String[] fields = rowType.getFieldNames();
        TypeInformation[] types = rowType.getFieldTypes();
        for (int i = 0; i < rowType.getArity(); ++i) {
            builder.addColumn(new CsvSchema.Column(i, fields[i], CsvRowSchemaConverter.convertType(fields[i], types[i])));
        }
        return builder.build();
    }

    public static CsvSchema convert(RowType rowType) {
        CsvSchema.Builder builder = new CsvSchema.Builder();
        List fields = rowType.getFields();
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            String fieldName = ((RowType.RowField)fields.get(i)).getName();
            LogicalType fieldType = ((RowType.RowField)fields.get(i)).getType();
            builder.addColumn(new CsvSchema.Column(i, fieldName, CsvRowSchemaConverter.convertType(fieldName, fieldType)));
        }
        return builder.build();
    }

    private static CsvSchema.ColumnType convertType(String fieldName, TypeInformation<?> info) {
        if (STRING_TYPES.contains(info)) {
            return CsvSchema.ColumnType.STRING;
        }
        if (NUMBER_TYPES.contains(info)) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (BOOLEAN_TYPES.contains(info)) {
            return CsvSchema.ColumnType.BOOLEAN;
        }
        if (info instanceof ObjectArrayTypeInfo) {
            CsvRowSchemaConverter.validateNestedField(fieldName, ((ObjectArrayTypeInfo)info).getComponentInfo());
            return CsvSchema.ColumnType.ARRAY;
        }
        if (info instanceof BasicArrayTypeInfo) {
            CsvRowSchemaConverter.validateNestedField(fieldName, ((BasicArrayTypeInfo)info).getComponentInfo());
            return CsvSchema.ColumnType.ARRAY;
        }
        if (info instanceof RowTypeInfo) {
            TypeInformation[] types;
            for (TypeInformation type : types = ((RowTypeInfo)info).getFieldTypes()) {
                CsvRowSchemaConverter.validateNestedField(fieldName, type);
            }
            return CsvSchema.ColumnType.ARRAY;
        }
        if (info instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)info).getComponentType() == Types.BYTE) {
            return CsvSchema.ColumnType.STRING;
        }
        throw new IllegalArgumentException("Unsupported type information '" + info.toString() + "' for field '" + fieldName + "'.");
    }

    private static CsvSchema.ColumnType convertType(String fieldName, LogicalType type) {
        if (STRING_TYPE_ROOTS.contains(type.getTypeRoot())) {
            return CsvSchema.ColumnType.STRING;
        }
        if (NUMBER_TYPE_ROOTS.contains(type.getTypeRoot())) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (BOOLEAN_TYPE_ROOTS.contains(type.getTypeRoot())) {
            return CsvSchema.ColumnType.BOOLEAN;
        }
        if (type.getTypeRoot() == LogicalTypeRoot.ARRAY) {
            CsvRowSchemaConverter.validateNestedField(fieldName, ((ArrayType)type).getElementType());
            return CsvSchema.ColumnType.ARRAY;
        }
        if (type.getTypeRoot() == LogicalTypeRoot.ROW) {
            RowType rowType = (RowType)type;
            for (LogicalType fieldType : rowType.getChildren()) {
                CsvRowSchemaConverter.validateNestedField(fieldName, fieldType);
            }
            return CsvSchema.ColumnType.ARRAY;
        }
        throw new IllegalArgumentException("Unsupported type '" + type.asSummaryString() + "' for field '" + fieldName + "'.");
    }

    private static void validateNestedField(String fieldName, TypeInformation<?> info) {
        if (!(NUMBER_TYPES.contains(info) || STRING_TYPES.contains(info) || BOOLEAN_TYPES.contains(info))) {
            throw new IllegalArgumentException("Only simple types are supported in the second level nesting of fields '" + fieldName + "' but was: " + info);
        }
    }

    private static void validateNestedField(String fieldName, LogicalType type) {
        if (!(NUMBER_TYPE_ROOTS.contains(type.getTypeRoot()) || STRING_TYPE_ROOTS.contains(type.getTypeRoot()) || BOOLEAN_TYPE_ROOTS.contains(type.getTypeRoot()))) {
            throw new IllegalArgumentException("Only simple types are supported in the second level nesting of fields '" + fieldName + "' but was: " + type.asSummaryString());
        }
    }
}

