/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate.utils;

import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.utils.DeduplicateFunctionHelper;
import org.apache.flink.util.Collector;

public abstract class RowTimeDeduplicateFunctionHelper {
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final int rowtimeIndex;
    private final boolean keepLastRow;

    public RowTimeDeduplicateFunctionHelper(boolean generateUpdateBefore, boolean generateInsert, int rowtimeIndex, boolean keepLastRow) {
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
        this.rowtimeIndex = rowtimeIndex;
        this.keepLastRow = keepLastRow;
    }

    public void deduplicateOnRowTime(RowData currentRow, @Nullable RowData prevRow, Collector<RowData> out) throws Exception {
        DeduplicateFunctionHelper.checkInsertOnly(currentRow);
        if (DeduplicateFunctionHelper.isDuplicate(prevRow, currentRow, this.rowtimeIndex, this.keepLastRow)) {
            DeduplicateFunctionHelper.updateDeduplicateResult(this.generateUpdateBefore, this.generateInsert, prevRow, currentRow, out);
            this.updateState(currentRow);
        }
    }

    protected abstract void updateState(RowData var1) throws Exception;
}

