/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class MapEntriesFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter keyElementGetter;
    private final ArrayData.ElementGetter valueElementGetter;

    public MapEntriesFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.MAP_ENTRIES, context);
        KeyValueDataType inputType = (KeyValueDataType)context.getCallContext().getArgumentDataTypes().get(0);
        this.keyElementGetter = ArrayData.createElementGetter((LogicalType)inputType.getKeyDataType().getLogicalType());
        this.valueElementGetter = ArrayData.createElementGetter((LogicalType)inputType.getValueDataType().getLogicalType());
    }

    @Nullable
    public ArrayData eval(@Nullable MapData input) {
        if (input == null) {
            return null;
        }
        ArrayData keys = input.keyArray();
        ArrayData values = input.valueArray();
        int size = input.size();
        Object[] resultData = new Object[size];
        for (int pos = 0; pos < size; ++pos) {
            Object key = this.keyElementGetter.getElementOrNull(keys, pos);
            Object value = this.valueElementGetter.getElementOrNull(values, pos);
            resultData[pos] = GenericRowData.of((Object[])new Object[]{key, value});
        }
        return new GenericArrayData(resultData);
    }
}

