/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.api.Executable;
import org.apache.flink.table.api.Explainable;

@Experimental
public interface CompiledPlan
extends Explainable<CompiledPlan>,
Executable {
    public String asJsonString();

    default public void writeToFile(String path) {
        this.writeToFile(Paths.get(path, new String[0]));
    }

    default public void writeToFile(String path, boolean ignoreIfExists) {
        this.writeToFile(Paths.get(path, new String[0]), ignoreIfExists);
    }

    default public void writeToFile(Path path) {
        this.writeToFile(path.toFile());
    }

    default public void writeToFile(Path path, boolean ignoreIfExists) {
        this.writeToFile(path.toFile(), ignoreIfExists);
    }

    default public void writeToFile(File file) {
        this.writeToFile(file, false);
    }

    public void writeToFile(File var1, boolean var2);

    public FlinkVersion getFlinkVersion();

    default public CompiledPlan printJsonString() {
        System.out.println(this.asJsonString());
        return this;
    }
}

