/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.WriteOperations;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.s3a.select.SelectBinding;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.fs.store.audit.AuditingFunctions;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class WriteOperationHelper
implements WriteOperations {
    private static final Logger LOG = LoggerFactory.getLogger(WriteOperationHelper.class);
    private final S3AFileSystem owner;
    private final Invoker invoker;
    private final Configuration conf;
    private final String bucket;
    private final S3AStatisticsContext statisticsContext;
    private final StoreContext storeContext;
    private final AuditSpanSource auditSpanSource;
    private AuditSpan auditSpan;
    private final RequestFactory requestFactory;

    protected WriteOperationHelper(S3AFileSystem owner, Configuration conf, S3AStatisticsContext statisticsContext, AuditSpanSource auditSpanSource, AuditSpan auditSpan) {
        this.owner = owner;
        this.invoker = new Invoker(new S3ARetryPolicy(conf), this::operationRetried);
        this.conf = conf;
        this.statisticsContext = statisticsContext;
        this.storeContext = owner.createStoreContext();
        this.bucket = owner.getBucket();
        this.auditSpanSource = auditSpanSource;
        this.auditSpan = Preconditions.checkNotNull(auditSpan);
        this.requestFactory = owner.getRequestFactory();
    }

    void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        LOG.info("{}: Retried {}: {}", new Object[]{text, retries, ex.toString()});
        LOG.debug("Stack", (Throwable)ex);
        this.owner.operationRetried(text, ex, retries, idempotent);
    }

    @Override
    public <T> T retry(String action, String path, boolean idempotent, CallableRaisingIOE<T> operation) throws IOException {
        this.activateAuditSpan();
        return this.invoker.retry(action, path, idempotent, operation);
    }

    public AuditSpan getAuditSpan() {
        return this.auditSpan;
    }

    private AuditSpan activateAuditSpan() {
        return this.auditSpan.activate();
    }

    private void deactivateAuditSpan() {
        this.auditSpan.deactivate();
    }

    @Override
    public PutObjectRequest createPutObjectRequest(String destKey, InputStream inputStream, long length, Map<String, String> headers) {
        this.activateAuditSpan();
        ObjectMetadata objectMetadata = this.newObjectMetadata(length);
        if (headers != null) {
            objectMetadata.setUserMetadata(headers);
        }
        return this.getRequestFactory().newPutObjectRequest(destKey, objectMetadata, inputStream);
    }

    @Override
    public PutObjectRequest createPutObjectRequest(String dest, File sourceFile) {
        Preconditions.checkState(sourceFile.length() < Integer.MAX_VALUE, "File length is too big for a single PUT upload");
        this.activateAuditSpan();
        return this.getRequestFactory().newPutObjectRequest(dest, this.newObjectMetadata((int)sourceFile.length()), sourceFile);
    }

    @Override
    public void writeSuccessful(long length) {
    }

    @Override
    public void writeFailed(Exception ex) {
        LOG.debug("Write to {} failed", (Object)this, (Object)ex);
    }

    @Override
    public ObjectMetadata newObjectMetadata(long length) {
        return this.getRequestFactory().newObjectMetadata(length);
    }

    @Override
    public String initiateMultiPartUpload(String destKey) throws IOException {
        LOG.debug("Initiating Multipart upload to {}", (Object)destKey);
        try (AuditSpan span = this.activateAuditSpan();){
            String string = this.retry("initiate MultiPartUpload", destKey, true, () -> {
                InitiateMultipartUploadRequest initiateMPURequest = this.getRequestFactory().newMultipartUploadRequest(destKey);
                return this.owner.initiateMultipartUpload(initiateMPURequest).getUploadId();
            });
            return string;
        }
    }

    private CompleteMultipartUploadResult finalizeMultipartUpload(String destKey, String uploadId, List<PartETag> partETags, long length, Invoker.Retried retrying, @Nullable BulkOperationState operationState) throws IOException {
        if (partETags.isEmpty()) {
            throw new PathIOException(destKey, "No upload parts in multipart upload");
        }
        try (AuditSpan span = this.activateAuditSpan();){
            CompleteMultipartUploadResult uploadResult = this.invoker.retry("Completing multipart upload", destKey, true, retrying, () -> {
                CompleteMultipartUploadRequest request = this.getRequestFactory().newCompleteMultipartUploadRequest(destKey, uploadId, partETags);
                return this.owner.getAmazonS3Client().completeMultipartUpload(request);
            });
            this.owner.finishedWrite(destKey, length, uploadResult.getETag(), uploadResult.getVersionId(), operationState);
            CompleteMultipartUploadResult completeMultipartUploadResult = uploadResult;
            return completeMultipartUploadResult;
        }
    }

    @Override
    public CompleteMultipartUploadResult completeMPUwithRetries(String destKey, String uploadId, List<PartETag> partETags, long length, AtomicInteger errorCount) throws IOException {
        Preconditions.checkNotNull(uploadId);
        Preconditions.checkNotNull(partETags);
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.finalizeMultipartUpload(destKey, uploadId, partETags, length, (text, e, r, i) -> errorCount.incrementAndGet(), null);
    }

    @Override
    public void abortMultipartUpload(String destKey, String uploadId, boolean shouldRetry, Invoker.Retried retrying) throws IOException {
        if (shouldRetry) {
            this.invoker.retry("Aborting multipart upload ID " + uploadId, destKey, true, retrying, AuditingFunctions.withinAuditSpan(this.getAuditSpan(), () -> this.owner.abortMultipartUpload(destKey, uploadId)));
        } else {
            Invoker.once("Aborting multipart upload ID " + uploadId, destKey, AuditingFunctions.withinAuditSpan(this.getAuditSpan(), () -> this.owner.abortMultipartUpload(destKey, uploadId)));
        }
    }

    @Override
    public void abortMultipartUpload(MultipartUpload upload) throws IOException {
        this.invoker.retry("Aborting multipart commit", upload.getKey(), true, AuditingFunctions.withinAuditSpan(this.getAuditSpan(), () -> this.owner.abortMultipartUpload(upload)));
    }

    @Override
    public int abortMultipartUploadsUnderPath(String prefix) throws IOException {
        LOG.debug("Aborting multipart uploads under {}", (Object)prefix);
        int count = 0;
        List<MultipartUpload> multipartUploads = this.listMultipartUploads(prefix);
        LOG.debug("Number of outstanding uploads: {}", (Object)multipartUploads.size());
        for (MultipartUpload upload : multipartUploads) {
            try {
                this.abortMultipartUpload(upload);
                ++count;
            }
            catch (FileNotFoundException e) {
                LOG.debug("Already aborted: {}", (Object)upload.getKey(), (Object)e);
            }
        }
        return count;
    }

    @Override
    public List<MultipartUpload> listMultipartUploads(String prefix) throws IOException {
        this.activateAuditSpan();
        return this.owner.listMultipartUploads(prefix);
    }

    @Override
    public void abortMultipartCommit(String destKey, String uploadId) throws IOException {
        this.abortMultipartUpload(destKey, uploadId, true, this.invoker.getRetryCallback());
    }

    @Override
    public UploadPartRequest newUploadPartRequest(String destKey, String uploadId, int partNumber, int size, InputStream uploadStream, File sourceFile, Long offset) throws IOException {
        return Invoker.once("upload part request", destKey, AuditingFunctions.withinAuditSpan(this.getAuditSpan(), () -> this.getRequestFactory().newUploadPartRequest(destKey, uploadId, partNumber, size, uploadStream, sourceFile, offset)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOperationHelper {bucket=").append(this.bucket);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws IOException {
        return this.retry("Writing Object", putObjectRequest.getKey(), true, AuditingFunctions.withinAuditSpan(this.getAuditSpan(), () -> this.owner.putObjectDirect(putObjectRequest)));
    }

    @Override
    public UploadResult uploadObject(PutObjectRequest putObjectRequest) throws IOException {
        return this.retry("Writing Object", putObjectRequest.getKey(), true, AuditingFunctions.withinAuditSpan(this.getAuditSpan(), () -> this.owner.executePut(putObjectRequest, null)));
    }

    @Override
    public void revertCommit(String destKey, @Nullable BulkOperationState operationState) throws IOException {
        Invoker.once("revert commit", destKey, AuditingFunctions.withinAuditSpan(this.getAuditSpan(), () -> {
            Path destPath = this.owner.keyToQualifiedPath(destKey);
            this.owner.deleteObjectAtPath(destPath, destKey, true, operationState);
            this.owner.maybeCreateFakeParentDirectory(destPath);
        }));
    }

    @Override
    public CompleteMultipartUploadResult commitUpload(String destKey, String uploadId, List<PartETag> partETags, long length, @Nullable BulkOperationState operationState) throws IOException {
        Preconditions.checkNotNull(uploadId);
        Preconditions.checkNotNull(partETags);
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.finalizeMultipartUpload(destKey, uploadId, partETags, length, Invoker.NO_OP, operationState);
    }

    @Override
    public BulkOperationState initiateCommitOperation(Path path) throws IOException {
        return this.initiateOperation(path, BulkOperationState.OperationType.Commit);
    }

    @Override
    public BulkOperationState initiateOperation(Path path, BulkOperationState.OperationType operationType) throws IOException {
        return S3Guard.initiateBulkWrite(this.owner.getMetadataStore(), operationType, path);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws IOException {
        return this.retry("upload part #" + request.getPartNumber() + " upload ID " + request.getUploadId(), request.getKey(), true, AuditingFunctions.withinAuditSpan(this.getAuditSpan(), () -> this.owner.uploadPart(request)));
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public SelectObjectContentRequest newSelectRequest(Path path) {
        try (AuditSpan span = this.getAuditSpan();){
            SelectObjectContentRequest selectObjectContentRequest = this.getRequestFactory().newSelectRequest(this.storeContext.pathToKey(path));
            return selectObjectContentRequest;
        }
    }

    @Override
    public SelectObjectContentResult select(Path source, SelectObjectContentRequest request, String action) throws IOException {
        String bucketName = request.getBucketName();
        Preconditions.checkArgument(this.bucket.equals(bucketName), "wrong bucket: %s", (Object)bucketName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initiating select call {} {}", (Object)source, (Object)request.getExpression());
            LOG.debug(SelectBinding.toString(request));
        }
        return this.invoker.retry(action, source.toString(), true, AuditingFunctions.withinAuditSpan(this.getAuditSpan(), () -> {
            Throwable throwable = null;
            try (DurationInfo ignored = new DurationInfo(LOG, "S3 Select operation", new Object[0]);){
                SelectObjectContentResult selectObjectContentResult = this.owner.getAmazonS3Client().selectObjectContent(request);
                return selectObjectContentResult;
            }
            catch (AmazonS3Exception e) {
                try {
                    LOG.error("Failure of S3 Select request against {}", (Object)source);
                    LOG.debug("S3 Select request against {}:\n{}", new Object[]{source, SelectBinding.toString(request), e});
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }));
    }

    public AuditSpan createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        return this.auditSpanSource.createSpan(operation, path1, path2);
    }

    @Override
    public void incrementWriteOperations() {
        this.owner.incrementWriteOperations();
    }

    @Override
    public void close() throws IOException {
        this.deactivateAuditSpan();
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }
}

